/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.status;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;

public final class ShutterStatus
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final int motionProfile;
    private final int isCalibrated;
    private final int smState;
    private final Map<ShutterSide, AxisStatus> axstatus;
    private final int isSafetyOn;
    private final List<Integer> temperature;

    public ShutterStatus(int motionProfile, boolean isCalibrated, int smState, Map<ShutterSide, AxisStatus> axes, boolean isSafetyOn, List<Integer> temperature) {
        this.motionProfile = motionProfile;
        this.isCalibrated = isCalibrated ? 1 : 0;
        this.smState = smState;
        this.axstatus = new EnumMap<ShutterSide, AxisStatus>(axes);
        int n = this.isSafetyOn = isSafetyOn ? 1 : 0;
        if (temperature == null || temperature.size() != 3) {
            throw new IllegalArgumentException("temperature list is null or has size != 3");
        }
        this.temperature = new ArrayList<Integer>(temperature);
    }

    public int getMotionProfile() {
        return this.motionProfile;
    }

    public boolean isCalibrated() {
        return this.isCalibrated == 1;
    }

    public int getSmState() {
        return this.smState;
    }

    public AxisStatus getAxisStatus(ShutterSide side) {
        return this.axstatus.get((Object)side);
    }

    public boolean isSafetyOn() {
        return this.isSafetyOn == 1;
    }

    public List<Integer> getTemperature() {
        return new ArrayList<Integer>(this.temperature);
    }

    public String toString() {
        StringBuilder buff = new StringBuilder("ShutterStatus{motionProfile=" + this.motionProfile + ", isCalibrated=" + this.isCalibrated + ", smState=" + this.smState + ", isSafetyOn=" + this.isSafetyOn + ", temperature=[" + this.temperature.get(0) + ", " + this.temperature.get(1) + ", " + this.temperature.get(2) + "]");
        for (ShutterSide side : ShutterSide.values()) {
            buff.append(", axstatus[");
            buff.append((Object)side);
            buff.append("]=");
            buff.append(this.getAxisStatus(side));
        }
        buff.append("}");
        return buff.toString();
    }

    public static final class AxisStatus
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final double actPos;
        private final double actVel;
        private final double setAcc;
        private final int enabled;
        private final int brakeEngaged;
        private final int lowLimit;
        private final int highLimit;
        private final int isHomed;
        private final int errorID;
        private final double motorTemp;

        public AxisStatus(double actPos, double actVel, double setAcc, boolean enabled, boolean brakeEngaged, boolean lowLimit, boolean highLimit, boolean isHomed, int errorID, double motorTemp) {
            this.actPos = actPos;
            this.actVel = actVel;
            this.setAcc = setAcc;
            this.enabled = enabled ? 1 : 0;
            this.brakeEngaged = brakeEngaged ? 1 : 0;
            this.lowLimit = lowLimit ? 1 : 0;
            this.highLimit = highLimit ? 1 : 0;
            this.isHomed = isHomed ? 1 : 0;
            this.errorID = errorID;
            this.motorTemp = motorTemp;
        }

        public String toString() {
            return "AxisStatus{actPos=" + this.actPos + ", actVel=" + this.actVel + ", setAcc=" + this.setAcc + ", enabled=" + this.enabled + ", brakeEngaged=" + this.brakeEngaged + ", lowLimit=" + this.lowLimit + ", highLimit=" + this.highLimit + ", isHomed=" + this.isHomed + ", errorID=" + this.errorID + ", motorTemp=" + this.motorTemp + '}';
        }

        public double getActPos() {
            return this.actPos;
        }

        public double getActVel() {
            return this.actVel;
        }

        public double getSetAcc() {
            return this.setAcc;
        }

        public boolean isEnabled() {
            return this.enabled == 1;
        }

        public boolean isBrakeEngaged() {
            return this.brakeEngaged == 1;
        }

        public boolean atLowLimit() {
            return this.lowLimit == 1;
        }

        public boolean atHighLimit() {
            return this.highLimit == 1;
        }

        public boolean isHomed() {
            return this.isHomed == 1;
        }

        public int getErrorID() {
            return this.errorID;
        }

        public double getMotorTemp() {
            return this.motorTemp;
        }
    }
}

