/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.shutter.common.Constants;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.gui.PluginActions;
import org.lsst.ccs.subsystem.shutter.gui.ShutterPlugin;
import org.lsst.ccs.subsystem.shutter.status.ShutterStatus;

public class ControlPanel
extends JPanel
implements PluginActions {
    private static final Logger LOG = Logger.getLogger(ControlPanel.class.getName());
    final ShutterPlugin plugin;
    final Map<ShutterSide, Boolean> brakeIsEngaged;
    final Map<ShutterSide, JTextField> brakeField;
    final Map<ShutterSide, JTextField> positionField;
    final Map<ShutterSide, JTextField> temperatureField;
    private JButton calibrateButton;
    private JTextField calibrationStateField;
    private JTextField ccsStateField;
    private JButton centerButton;
    private JButton closeButton;
    private JLabel exposureTimeLabel;
    private JSpinner exposureTimeSpinner;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JButton minusXBrakeButton;
    private JTextField minusXBrakeField;
    private JTextField minusXPositionField;
    private JLabel minusXPositionLabel;
    private JTextField minusXTemperatureField;
    private JButton openButton;
    private JButton plusXBrakeButton;
    private JTextField plusXBrakeField;
    private JTextField plusXPositionField;
    private JLabel plusXPositionLabel;
    private JTextField plusXTemperatureField;
    private JButton prodModeButton;
    private JButton resyncButton;
    private JLabel secondsLabel;
    private JTextField shutterStateField;
    private JButton stopButton;
    private JButton takeExposureButton;

    public ControlPanel(ShutterPlugin plugin) {
        this.plugin = plugin;
        this.initComponents();
        this.brakeIsEngaged = new EnumMap<ShutterSide, Boolean>(ShutterSide.class);
        this.brakeIsEngaged.put(ShutterSide.PLUSX, null);
        this.brakeIsEngaged.put(ShutterSide.MINUSX, null);
        this.brakeField = new EnumMap<ShutterSide, JTextField>(ShutterSide.class);
        this.brakeField.put(ShutterSide.PLUSX, this.plusXBrakeField);
        this.brakeField.put(ShutterSide.MINUSX, this.minusXBrakeField);
        this.positionField = new EnumMap<ShutterSide, JTextField>(ShutterSide.class);
        this.positionField.put(ShutterSide.PLUSX, this.plusXPositionField);
        this.positionField.put(ShutterSide.MINUSX, this.minusXPositionField);
        this.temperatureField = new EnumMap<ShutterSide, JTextField>(ShutterSide.class);
        this.temperatureField.put(ShutterSide.PLUSX, this.plusXTemperatureField);
        this.temperatureField.put(ShutterSide.MINUSX, this.minusXTemperatureField);
    }

    @Override
    public void showCommandFailure(String message) {
        LOG.log(Level.FINE, "showCommandFailure(): {0}", message);
    }

    @Override
    public void showCommandSuccess() {
        LOG.fine("showCommandSuccess()");
    }

    @Override
    public void showStateBundle(PhysicalState phys, SoftwareState soft) {
        LOG.log(Level.FINE, "Physical state is {0}, software state is {1}.", new Object[]{phys, soft});
        SwingUtilities.invokeLater(() -> {
            this.shutterStateField.setText(phys.toString());
            this.ccsStateField.setText(soft.getDescription());
        });
    }

    @Override
    public void showStatus(ShutterStatus status) {
        SwingUtilities.invokeLater(() -> {
            this.calibrationStateField.setText(status.isCalibrated() ? "YES" : "NO");
            for (ShutterSide side : ShutterSide.values()) {
                ShutterStatus.AxisStatus axstatus = status.getAxisStatus(side);
                this.brakeIsEngaged.put(side, axstatus.isBrakeEngaged());
                this.brakeField.get(side).setText(this.brakeIsEngaged.get(side) != false ? "ENGAGED" : "RELEASED");
                double pos = axstatus.getActPos();
                double home = (Double)Constants.BLADE_SET_HOME.get(side);
                double percent = 100.0 * Math.abs(pos - home) / 750.0;
                String strpos = String.format("% 5.1f mm = % 5.1f%%", pos, percent);
                this.positionField.get(side).setText(strpos);
                String strtemp = String.format("% 5.1f \u2103", axstatus.getMotorTemp());
                this.temperatureField.get(side).setText(strtemp);
            }
        });
    }

    @Override
    public void showWorkerIsReachable() {
        SwingUtilities.invokeLater(() -> this.setEnabled(true));
    }

    @Override
    public void showWorkerIsUnreachable(String message) {
        LOG.fine(message);
        SwingUtilities.invokeLater(() -> this.setEnabled(false));
    }

    private void initComponents() {
        this.takeExposureButton = new JButton();
        this.exposureTimeLabel = new JLabel();
        this.exposureTimeSpinner = new JSpinner();
        this.secondsLabel = new JLabel();
        this.closeButton = new JButton();
        this.openButton = new JButton();
        this.jLabel1 = new JLabel();
        this.shutterStateField = new JTextField();
        this.stopButton = new JButton();
        this.calibrateButton = new JButton();
        this.resyncButton = new JButton();
        this.centerButton = new JButton();
        this.prodModeButton = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.plusXBrakeButton = new JButton();
        this.plusXBrakeField = new JTextField();
        this.minusXBrakeButton = new JButton();
        this.minusXBrakeField = new JTextField();
        this.plusXPositionLabel = new JLabel();
        this.plusXPositionField = new JTextField();
        this.minusXPositionLabel = new JLabel();
        this.minusXPositionField = new JTextField();
        this.jLabel2 = new JLabel();
        this.ccsStateField = new JTextField();
        this.jLabel3 = new JLabel();
        this.minusXTemperatureField = new JTextField();
        this.jLabel4 = new JLabel();
        this.plusXTemperatureField = new JTextField();
        this.jLabel5 = new JLabel();
        this.calibrationStateField = new JTextField();
        this.takeExposureButton.setText("Take exposure");
        this.takeExposureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlPanel.this.handleTakeExposure(evt);
            }
        });
        this.exposureTimeLabel.setText("Exposure time:");
        this.exposureTimeSpinner.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(0.1f), Float.valueOf(3600.0f), Float.valueOf(0.1f)));
        this.secondsLabel.setText("seconds");
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlPanel.this.handleCloseShutter(evt);
            }
        });
        this.openButton.setText("Open");
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlPanel.this.handleOpenShutter(evt);
            }
        });
        this.jLabel1.setText("Shutter state:");
        this.shutterStateField.setEditable(false);
        this.shutterStateField.setHorizontalAlignment(2);
        this.stopButton.setBackground(new Color(255, 0, 51));
        this.stopButton.setText("Stop/reset");
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlPanel.this.handleStop(evt);
            }
        });
        this.calibrateButton.setText("Calibrate");
        this.calibrateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlPanel.this.handleCalibrate(evt);
            }
        });
        this.resyncButton.setText("Resync");
        this.resyncButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlPanel.this.handleResync(evt);
            }
        });
        this.centerButton.setText("Center");
        this.centerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlPanel.this.handleCenter(evt);
            }
        });
        this.prodModeButton.setText("Prod mode");
        this.prodModeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlPanel.this.handleProdMode(evt);
            }
        });
        this.plusXBrakeButton.setText("+X brake");
        this.plusXBrakeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlPanel.this.handlePlusXBrake(evt);
            }
        });
        this.plusXBrakeField.setEditable(false);
        this.minusXBrakeButton.setText("-X brake");
        this.minusXBrakeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlPanel.this.handleMinusXBrake(evt);
            }
        });
        this.minusXBrakeField.setEditable(false);
        this.plusXPositionLabel.setText("+X posn");
        this.plusXPositionField.setEditable(false);
        this.minusXPositionLabel.setText("-X posn");
        this.minusXPositionField.setEditable(false);
        this.jLabel2.setText("CCS state:");
        this.ccsStateField.setEditable(false);
        this.jLabel3.setText("-X temp");
        this.minusXTemperatureField.setEditable(false);
        this.jLabel4.setText("+X temp");
        this.plusXTemperatureField.setEditable(false);
        this.jLabel5.setText("Shutter calibrated?");
        this.calibrationStateField.setEditable(false);
        this.calibrationStateField.setText("      ");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jSeparator3).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.calibrateButton).addGap(18, 18, 18).addComponent(this.prodModeButton).addGap(18, 18, 18).addComponent(this.resyncButton).addGap(26, 26, 26).addComponent(this.centerButton)).addGroup(layout.createSequentialGroup().addComponent(this.plusXBrakeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.plusXBrakeField, -2, 112, -2).addGap(18, 18, 18).addComponent(this.minusXBrakeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minusXBrakeField, -2, 112, -2))).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.shutterStateField, -2, 136, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ccsStateField, -2, 276, -2).addGap(18, 18, 18).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.calibrationStateField, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.stopButton)).addComponent(this.jSeparator2).addGroup(layout.createSequentialGroup().addComponent(this.takeExposureButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exposureTimeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exposureTimeSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.secondsLabel).addGap(18, 18, 18).addComponent(this.closeButton).addGap(18, 18, 18).addComponent(this.openButton).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minusXTemperatureField)).addGroup(layout.createSequentialGroup().addComponent(this.minusXPositionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minusXPositionField, -2, 151, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.plusXPositionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.plusXPositionField, -2, 150, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.plusXTemperatureField))).addGap(0, 59, Short.MAX_VALUE))).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.shutterStateField, -2, -1, -2).addComponent(this.stopButton, -2, 43, -2).addComponent(this.jLabel2).addComponent(this.ccsStateField, -2, -1, -2).addComponent(this.jLabel5).addComponent(this.calibrationStateField, -2, -1, -2)).addGap(32, 32, 32).addComponent(this.jSeparator3, -2, 15, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.takeExposureButton).addComponent(this.exposureTimeLabel).addComponent(this.exposureTimeSpinner, -2, -1, -2).addComponent(this.secondsLabel, -1, -1, Short.MAX_VALUE).addComponent(this.closeButton).addComponent(this.openButton).addComponent(this.minusXPositionLabel, -2, 43, -2).addComponent(this.minusXPositionField, -2, -1, -2).addComponent(this.plusXPositionLabel, -2, 18, -2).addComponent(this.plusXPositionField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.minusXTemperatureField, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.plusXTemperatureField, -2, -1, -2)).addGap(4, 4, 4).addComponent(this.jSeparator2, -2, 19, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.calibrateButton).addComponent(this.prodModeButton).addComponent(this.resyncButton).addComponent(this.centerButton)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.plusXBrakeButton).addComponent(this.plusXBrakeField, -2, -1, -2).addComponent(this.minusXBrakeButton).addComponent(this.minusXBrakeField, -2, -1, -2)).addContainerGap()));
    }

    private void handleTakeExposure(ActionEvent evt) {
        this.plugin.getDispatcher().takeExposure(this.getExposureTime());
    }

    private void handleCloseShutter(ActionEvent evt) {
        this.plugin.getDispatcher().closeShutter();
    }

    private void handleOpenShutter(ActionEvent evt) {
        this.plugin.getDispatcher().openShutter();
    }

    private void handleStop(ActionEvent evt) {
        this.plugin.getDispatcher().stopMotion();
    }

    private void handleCalibrate(ActionEvent evt) {
        this.plugin.getDispatcher().calibrate();
    }

    private void handleProdMode(ActionEvent evt) {
        this.plugin.getDispatcher().prodMode();
    }

    private void handleResync(ActionEvent evt) {
        this.plugin.getDispatcher().resync();
    }

    private void handleCenter(ActionEvent evt) {
        this.plugin.getDispatcher().center();
    }

    private void handlePlusXBrake(ActionEvent evt) {
        Boolean state = this.brakeIsEngaged.get(ShutterSide.PLUSX);
        if (state != null) {
            this.plugin.getDispatcher().changeBrakeState(ShutterSide.PLUSX, state == false);
        }
    }

    private void handleMinusXBrake(ActionEvent evt) {
        Boolean state = this.brakeIsEngaged.get(ShutterSide.MINUSX);
        if (state != null) {
            this.plugin.getDispatcher().changeBrakeState(ShutterSide.MINUSX, state == false);
        }
    }

    public double getExposureTime() {
        return ((Number)this.exposureTimeSpinner.getValue()).doubleValue();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.takeExposureButton.setEnabled(enabled);
        this.exposureTimeSpinner.setEnabled(enabled);
        this.closeButton.setEnabled(enabled);
        this.openButton.setEnabled(enabled);
        this.calibrateButton.setEnabled(enabled);
        this.prodModeButton.setEnabled(enabled);
        this.resyncButton.setEnabled(enabled);
        this.centerButton.setEnabled(enabled);
        this.stopButton.setEnabled(enabled);
        this.plusXBrakeButton.setEnabled(enabled);
        this.minusXBrakeButton.setEnabled(enabled);
        if (!enabled) {
            this.shutterStateField.setText("");
            this.ccsStateField.setText("");
            this.calibrationStateField.setText("");
            for (ShutterSide side : ShutterSide.values()) {
                this.brakeField.get(side).setText("");
                this.positionField.get(side).setText("");
                this.temperatureField.get(side).setText("");
            }
        }
    }
}

