/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystems.shutter.common.ShutterSide;
import org.lsst.ccs.subsystems.shutter.gui.ShutterControlPanel;
import org.lsst.ccs.subsystems.shutter.gui.ShutterDisplay;
import org.lsst.ccs.subsystems.shutter.status.BladePositionResult;
import org.lsst.ccs.subsystems.shutter.status.CloseShutterStatus;
import org.lsst.ccs.subsystems.shutter.status.MoveToPositionStatus;
import org.lsst.ccs.subsystems.shutter.status.MovementHistoryStatus;
import org.lsst.ccs.subsystems.shutter.status.OpenShutterStatus;
import org.lsst.ccs.subsystems.shutter.status.ReadyForActionStatus;
import org.lsst.ccs.subsystems.shutter.status.StatusKey;
import org.lsst.ccs.subsystems.shutter.status.TakeExposureStatus;

public class ShutterGUISubsystem
implements CommandOriginator,
StatusMessageListener {
    static final String shutterWorkerName = "ccs-shutter";
    private AgentMessagingLayer msglayer;
    private final ShutterDisplay display = new ShutterDisplay();
    private final ShutterControlPanel control = new ShutterControlPanel();
    private final ScheduledExecutorService pingerExec = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> pinger;

    public static void main(String[] args) throws InterruptedException, InvocationTargetException {
        Agent guiAgent = new Agent("Shutter GUI", AgentInfo.AgentType.LISTENER);
        ShutterGUISubsystem shutterGUI = new ShutterGUISubsystem();
        shutterGUI.initGui(guiAgent.getMessagingAccess());
        JFrame frame = new JFrame("Shutter GUI demo");
        SwingUtilities.invokeLater(() -> {
            frame.getRootPane().setDoubleBuffered(true);
            frame.getContentPane().add((Component)shutterGUI.getDisplayComponent(), "Center");
            frame.getContentPane().add((Component)shutterGUI.getControlsComponent(), "South");
            frame.setDefaultCloseOperation(3);
            frame.setResizable(true);
            frame.pack();
            frame.setVisible(true);
        });
    }

    public void initGui(AgentMessagingLayer aml) {
        this.msglayer = aml;
        SwingUtilities.invokeLater(() -> {
            this.control.setEnabled(false);
            this.setUpActionListeners(this.control);
        });
        this.pinger = this.pingerExec.scheduleWithFixedDelay(() -> {
            CommandRequest cmd = new CommandRequest(shutterWorkerName, "getBladeSetPositions");
            try {
                aml.sendCommandRequest(cmd, (CommandOriginator)this);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }, 0L, 5L, TimeUnit.SECONDS);
    }

    public JComponent getDisplayComponent() {
        return this.display;
    }

    public JComponent getControlsComponent() {
        return this.control;
    }

    public void sendMoveToPosition(ShutterSide side, double targetPosition) {
        Double arg2 = targetPosition;
        String command = "moveToPosition";
        CommandRequest cmd = new CommandRequest(shutterWorkerName, command, new Object[]{side, arg2});
        this.msglayer.sendCommandRequest(cmd, (CommandOriginator)this);
    }

    public void sendTakeExposure(double exposureTime) {
        Double arg1 = exposureTime;
        String command = "takeExposure";
        CommandRequest cmd = new CommandRequest(shutterWorkerName, command, new Object[]{arg1});
        this.msglayer.sendCommandRequest(cmd, (CommandOriginator)this);
    }

    public void sendCloseShutter() {
        CommandRequest cmd = new CommandRequest(shutterWorkerName, "closeShutter");
        this.msglayer.sendCommandRequest(cmd, (CommandOriginator)this);
    }

    public void sendOpenShutter() {
        CommandRequest cmd = new CommandRequest(shutterWorkerName, "openShutter");
        this.msglayer.sendCommandRequest(cmd, (CommandOriginator)this);
    }

    public void onStatusMessage(StatusMessage s) {
        StatusSubsystemData data = (StatusSubsystemData)s;
        if (data.getDataKey().equals(StatusKey.MOVEMENT.getKey())) {
            System.out.println("~_~_~_~_~_~MovementStatus_~_~_~_~_~_~_~_");
            SwingUtilities.invokeLater(() -> this.display.showActualMovement((MovementHistoryStatus)this.extract(data)));
        } else if (data.getDataKey().equals(StatusKey.MOVE_BLADE_SET.getKey())) {
            System.out.println("~_~_~_~_~_~_~MoveBladeSetStatus_~_~_~_~_~_~_");
            SwingUtilities.invokeLater(() -> {
                this.control.setEnabled(false);
                this.display.showPredictedMoveTo((MoveToPositionStatus)this.extract(data));
            });
        } else if (data.getDataKey().equals(StatusKey.UNSAFE_MOVE.getKey())) {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.display, "Unsafe move", "Operator error", 0));
        } else if (data.getDataKey().equals(StatusKey.TAKE_EXPOSURE.getKey())) {
            System.out.println("~_~_~_~_~_~_TakeExposureStatus~_~_~_~_~_~_~_");
            SwingUtilities.invokeLater(() -> {
                this.control.setEnabled(false);
                this.display.showPredictedExposure((TakeExposureStatus)this.extract(data));
            });
        } else if (data.getDataKey().equals(StatusKey.READY.getKey())) {
            System.out.println("~_~_~_~_~_~_ReadyForActionStatus~_~_~_~_~_~_~_");
            ReadyForActionStatus status = (ReadyForActionStatus)this.extract(data);
            SwingUtilities.invokeLater(() -> this.control.setEnabled(status.isReadyForAction()));
        } else if (data.getDataKey().equals(StatusKey.CLOSE_SHUTTER.getKey())) {
            System.out.println("~_~_~_~_~_~_CloseShutterStatus~_~_~_~_~_~_~_");
            SwingUtilities.invokeLater(() -> {
                this.control.setEnabled(false);
                this.display.showPredictedClose((CloseShutterStatus)this.extract(data));
            });
        } else if (data.getDataKey().equals(StatusKey.OPEN_SHUTTER.getKey())) {
            System.out.println("~_~_~_~_~_~_OpenShutterStatus~_~_~_~_~_~_~_");
            SwingUtilities.invokeLater(() -> {
                this.control.setEnabled(false);
                this.display.showPredictedOpen((OpenShutterStatus)this.extract(data));
            });
        }
    }

    private Serializable extract(StatusSubsystemData data) {
        KeyValueData kval = data.getSubsystemData();
        return kval.getValue();
    }

    public void processAck(CommandAck ack) {
    }

    public void processNack(CommandNack nack) {
    }

    public void processResult(CommandResult res) {
        boolean ok = res.wasSuccessful();
        Object obj = res.getResult();
        if (ok && obj instanceof BladePositionResult) {
            this.pinger.cancel(true);
            this.pingerExec.shutdown();
            BladePositionResult pos = (BladePositionResult)obj;
            SwingUtilities.invokeLater(() -> {
                this.display.setBladeSetPositions(pos.getPlusx(), pos.getMinusx());
                this.display.repaint();
                this.control.setEnabled(true);
            });
        }
    }

    public void setUpActionListeners(final ShutterControlPanel control) {
        control.addTakeExposureActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("ShutterGUI: sending TakeImage command");
                ShutterGUISubsystem.this.sendTakeExposure(control.getExposureTime());
                System.out.println("ShutterGUI: sent TakeImage command");
            }
        });
        control.addMoveToActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("ShutterGUI: sending MoveToPosition command");
                ShutterGUISubsystem.this.sendMoveToPosition(control.getSide(), control.getTargetPosition());
                System.out.println("ShutterGUI: sent MoveToPosition command");
            }
        });
        control.addCloseShutterActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("ShutterGUI: sending CloseShutter command");
                ShutterGUISubsystem.this.sendCloseShutter();
                System.out.println("ShutterGUI: sent CloseShutter command");
            }
        });
        control.addOpenShutterActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("ShutterGUI: sending OpenShutter command");
                ShutterGUISubsystem.this.sendOpenShutter();
                System.out.println("ShutterGUI: sent OpenShutter command");
            }
        });
    }
}

