/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.gui.jas;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelManager;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.subsystems.shutter.gui.ShutterGUISubsystem;
import org.lsst.ccs.utilities.logging.Logger;

@Plugin(name="ShutterGUI", description="Camera shutter status display.")
public class ShutterPlugin
extends ConsolePlugin
implements AgentPresenceListener {
    private static final Logger LOG = Logger.getLogger((String)ShutterPlugin.class.getPackage().getName());
    private volatile ShutterGUISubsystem subsys;
    private volatile JPanel shutterPanel;
    private volatile JScrollPane scrollPane;
    private volatile PanelManager pm;

    public void initialize() {
        this.pm = this.getConsole().getPanelManager();
        AbstractAction openShutterGui = new AbstractAction("Shutter"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ShutterPlugin.this.subsys == null) {
                    ShutterPlugin.this.subsys = new ShutterGUISubsystem();
                    ShutterPlugin.this.shutterPanel = new JPanel();
                    ShutterPlugin.this.shutterPanel.setLayout(new BorderLayout());
                    ShutterPlugin.this.shutterPanel.add((Component)ShutterPlugin.this.subsys.getDisplayComponent(), "Center");
                    ShutterPlugin.this.shutterPanel.add((Component)ShutterPlugin.this.subsys.getControlsComponent(), "South");
                    ShutterPlugin.this.scrollPane = new JScrollPane(ShutterPlugin.this.shutterPanel);
                    ShutterPlugin.this.pm.open((Component)ShutterPlugin.this.scrollPane, "Camera Shutter Control Panel");
                    ShutterPlugin.this.initTask();
                } else {
                    ShutterPlugin.this.closeMonitorGUI();
                }
            }
        };
        this.pm.addListener(e -> {
            if (e.hasKey((Object)Panel.OPEN) && !((Boolean)e.getNewValue()).booleanValue() && e.getSource().equals(this.scrollPane)) {
                this.closeMonitorGUI();
                openShutterGui.putValue("SwingSelectedKey", false);
            }
        });
        openShutterGui.putValue("SwingSelectedKey", false);
        this.getServices().addMenu((Action)openShutterGui, new String[]{"CCS Subsystems"});
    }

    private void closeMonitorGUI() {
        this.pm.close((Component)this.scrollPane);
        this.scrollPane = null;
        this.closeTask();
        this.subsys = null;
    }

    private void initTask() {
        this.subsys.initGui(Agent.getEnvironmentMessagingAccess());
        this.getConsole().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
    }

    private void closeTask() {
        this.getConsole().getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener((AgentPresenceListener)this);
    }

    public void start() {
    }

    public void stop() {
    }

    public void shutdown() {
        if (this.subsys != null) {
            this.closeTask();
        }
    }

    public void connected(AgentInfo ... agentArray) {
        for (AgentInfo agent : agentArray) {
            if (!agent.hasAgentProperty("Foo")) continue;
        }
    }

    public void disconnecting(AgentInfo agent) {
        if (agent.hasAgentProperty("foo")) {
            // empty if block
        }
    }
}

