/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.lsst.ccs.subsystems.shutter.common.BladePosition;
import org.lsst.ccs.subsystems.shutter.common.HallTransition;
import org.lsst.ccs.subsystems.shutter.common.ShutterSide;
import org.lsst.ccs.subsystems.shutter.gui.EncoderReadOut;
import org.lsst.ccs.subsystems.shutter.gui.HallSensorHistory;
import org.lsst.ccs.subsystems.shutter.gui.MotorHistory;
import org.lsst.ccs.subsystems.shutter.gui.PlotPanelNew;
import org.lsst.ccs.subsystems.shutter.gui.ShutterAssembly;
import org.lsst.ccs.subsystems.shutter.sim.CubicSCurve;
import org.lsst.ccs.subsystems.shutter.sim.MotionProfile;
import org.lsst.ccs.subsystems.shutter.sim.MotorSimulator;
import org.lsst.ccs.subsystems.shutter.status.CloseShutterStatus;
import org.lsst.ccs.subsystems.shutter.status.MoveToPositionStatus;
import org.lsst.ccs.subsystems.shutter.status.MovementHistoryStatus;
import org.lsst.ccs.subsystems.shutter.status.OpenShutterStatus;
import org.lsst.ccs.subsystems.shutter.status.TakeExposureStatus;

public class ShutterDisplay
extends JPanel {
    private final ShutterAssembly assembly;
    private PlotPanelNew plotPanel;
    private Map<ShutterSide, MotorHistory> motorHistories = new EnumMap<ShutterSide, MotorHistory>(ShutterSide.class);
    private Map<ShutterSide, HallSensorHistory> hallSensorHistories = new EnumMap<ShutterSide, HallSensorHistory>(ShutterSide.class);
    private Map<ShutterSide, EncoderReadOut> encoderReadOuts = new EnumMap<ShutterSide, EncoderReadOut>(ShutterSide.class);
    private long timeOrigin = 0L;
    private static final double MOTOR_SAMPLING_INTERVAL = 0.05;

    public ShutterDisplay() {
        super(new BorderLayout());
        this.assembly = new ShutterAssembly();
        this.motorHistories.put(ShutterSide.PLUSX, new MotorHistory());
        this.motorHistories.put(ShutterSide.MINUSX, new MotorHistory());
        this.hallSensorHistories.put(ShutterSide.PLUSX, new HallSensorHistory());
        this.hallSensorHistories.put(ShutterSide.MINUSX, new HallSensorHistory());
        this.encoderReadOuts.put(ShutterSide.PLUSX, new EncoderReadOut());
        this.encoderReadOuts.put(ShutterSide.MINUSX, new EncoderReadOut());
        this.plotPanel = new PlotPanelNew(this.motorHistories, this.hallSensorHistories, this.encoderReadOuts);
        JSplitPane split = new JSplitPane(1);
        split.add(this.plotPanel);
        split.add(this.assembly);
        this.add((Component)split, "Center");
    }

    public void setBladeSetPositions(double plus, double minus) {
        this.assembly.getShutter(ShutterSide.PLUSX).setShutterPosition((float)plus);
        this.assembly.getShutter(ShutterSide.MINUSX).setShutterPosition((float)minus);
        this.assembly.setVisible(true);
        this.assembly.repaint();
    }

    public void hideAssembly() {
        this.assembly.setVisible(false);
        this.assembly.repaint();
    }

    private void startNewCommand(long t0, float tSpan) {
        for (ShutterSide side : ShutterSide.values()) {
            this.motorHistories.get(side).reset();
            this.hallSensorHistories.get(side).reset();
            this.encoderReadOuts.get(side).reset();
        }
        this.plotPanel.setTimePeriod(tSpan);
        this.timeOrigin = t0;
    }

    Map<ShutterSide, MotorHistory> getHistories() {
        return this.motorHistories;
    }

    public void showPredictedMoveTo(MoveToPositionStatus moveStat) {
        this.startNewCommand(moveStat.getStartTime(), (float)moveStat.getMoveTime());
        this.showPredictedMovement(moveStat.getSide(), moveStat.getStartingPosition(), moveStat.getTargetPosition(), moveStat.getMoveTime(), 0L);
    }

    public void showPredictedMovement(ShutterSide side, double startingPosition, double targetPosition, double moveTime, long startTime) {
        System.out.println("ShutterDisplay: startingPosition " + startingPosition + " targetPosition  " + targetPosition + " moveTimeSeconds " + moveTime);
        MotorSimulator motor = new MotorSimulator(startingPosition, 0.05, 1 + (int)Math.floor(moveTime / 0.05), startTime, (MotionProfile)new CubicSCurve(targetPosition - startingPosition, moveTime));
        this.motorHistories.get(side).addData(motor.getPositions());
    }

    void showPredictedExposure(TakeExposureStatus exposeStat) {
        float moveTime = (float)exposeStat.getMoveTime();
        float exposureTime = (float)exposeStat.getExposureTime();
        ShutterSide firstSide = exposeStat.getFirstSide();
        ShutterSide secondSide = firstSide.opposite();
        float firstStartingPosition = this.assembly.getShutter(firstSide).getShutterPosition();
        float secondStartingPosition = this.assembly.getShutter(secondSide).getShutterPosition();
        float firstTargetPosition = 0.0f;
        float secondTargetPosition = 1.0f;
        this.startNewCommand(exposeStat.getStartTime(), moveTime + exposureTime);
        this.showPredictedMovement(firstSide, firstStartingPosition, 0.0, moveTime, 0L);
        this.showPredictedMovement(secondSide, secondStartingPosition, 1.0, moveTime, (long)(1000000.0 * (double)exposureTime));
    }

    void showPredictedClose(CloseShutterStatus closeStat) {
        float moveTime = (float)closeStat.getMoveTime();
        ShutterSide firstSide = closeStat.getFirstSide();
        ShutterSide secondSide = firstSide.opposite();
        System.out.println("****** ShutterDisplay closeShutter: moveTime " + moveTime + " *********");
        this.startNewCommand(closeStat.getStartTime(), 2.0f * moveTime);
        this.showPredictedMovement(firstSide, this.assembly.getShutter(firstSide).getShutterPosition(), 0.0, moveTime, 0L);
        this.showPredictedMovement(secondSide, this.assembly.getShutter(secondSide).getShutterPosition(), 1.0, moveTime, (long)(1000000.0 * (double)moveTime));
    }

    void showPredictedOpen(OpenShutterStatus openStat) {
        float moveTime = (float)openStat.getMoveTime();
        ShutterSide firstSide = openStat.getfirstSide();
        ShutterSide secondSide = firstSide.opposite();
        System.out.println("****** ShutterDisplay openShutter: moveTime " + moveTime + " *********");
        this.startNewCommand(openStat.getStartTime(), 2.0f * moveTime);
        this.showPredictedMovement(firstSide, this.assembly.getShutter(firstSide).getShutterPosition(), 0.0, moveTime, 0L);
        this.showPredictedMovement(secondSide, this.assembly.getShutter(secondSide).getShutterPosition(), 0.0, moveTime, (long)(1000000.0 * (double)moveTime));
    }

    void showActualMovement(MovementHistoryStatus moveStat) {
        System.out.println("****** showActualMovement *********");
        ShutterSide side = moveStat.getSide();
        this.showActualMotorPositions(side, moveStat.getHistory().getPositions());
        this.showActualHallTransitions(side, moveStat.getHistory().getHallTransitions());
    }

    private void showActualMotorPositions(ShutterSide side, List<BladePosition> pos) {
        System.out.println("********** showActualMotorPositions " + pos.size() + " ************");
        this.assembly.getShutter(side).setShutterPosition((float)pos.get(pos.size() - 1).getRelPosition());
        this.assembly.repaint();
        this.encoderReadOuts.get(side).addData(pos, this.timeOrigin);
        for (BladePosition p : pos) {
            System.out.println("UI : set " + side + " Time" + p.getTime() + " position " + p.getRelPosition());
        }
    }

    void showActualHallTransitions(ShutterSide side, List<HallTransition> trans) {
        System.out.println("************ showActualHallTransitions " + trans.size() + " ************");
        this.hallSensorHistories.get(side).addData(trans, this.timeOrigin);
        for (HallTransition h : trans) {
            System.out.println("UI: set " + side + " Time " + h.getTransitionTime() + " position " + h.getPosition());
            System.out.println("UI: set " + side + " ID " + h.getSensorId() + " State " + h.isOpen() + " retracting " + h.isReverse());
        }
    }
}

