/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.gui;

import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import org.lsst.ccs.subsystems.shutter.common.ShutterSide;

public class ShutterControlPanel
extends JPanel {
    private JLabel bladeSetLabel;
    private JSpinner bladeSetSpinner;
    private JButton closeShutterButton;
    private JLabel exposureTimeLabel;
    private JSpinner exposureTimeSpinner;
    private JButton moveToButton;
    private JSpinner moveToSpinner;
    private JButton openShutterButton;
    private JLabel secondsLabel;
    private JButton takeExposureButton;
    private JLabel toPositionLabel;

    public ShutterControlPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.takeExposureButton = new JButton();
        this.exposureTimeLabel = new JLabel();
        this.exposureTimeSpinner = new JSpinner();
        this.secondsLabel = new JLabel();
        this.moveToButton = new JButton();
        this.moveToSpinner = new JSpinner();
        this.bladeSetSpinner = new JSpinner();
        this.bladeSetLabel = new JLabel();
        this.toPositionLabel = new JLabel();
        this.closeShutterButton = new JButton();
        this.openShutterButton = new JButton();
        this.takeExposureButton.setText("Take Exposure");
        this.exposureTimeLabel.setText("Exposure Time:");
        this.exposureTimeSpinner.setModel(new SpinnerNumberModel(Float.valueOf(5.0f), Float.valueOf(1.0f), Float.valueOf(20.0f), Float.valueOf(0.1f)));
        this.secondsLabel.setText("seconds");
        this.moveToButton.setText("Move");
        this.moveToSpinner.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.05f)));
        this.moveToSpinner.setMinimumSize(new Dimension(50, 18));
        this.bladeSetSpinner.setModel(new SpinnerListModel(new String[]{"+X", "-X"}));
        this.bladeSetLabel.setText("Blade set:");
        this.toPositionLabel.setText("to position");
        this.closeShutterButton.setText("Close Shutter");
        this.openShutterButton.setText("Open Shutter");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.takeExposureButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exposureTimeLabel).addGap(4, 4, 4).addComponent(this.exposureTimeSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.secondsLabel)).addGroup(layout.createSequentialGroup().addComponent(this.moveToButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bladeSetLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bladeSetSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toPositionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveToSpinner, -2, 75, -2)).addGroup(layout.createSequentialGroup().addComponent(this.closeShutterButton).addGap(18, 18, 18).addComponent(this.openShutterButton))).addContainerGap(83, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.takeExposureButton).addComponent(this.exposureTimeLabel).addComponent(this.exposureTimeSpinner, -2, -1, -2).addComponent(this.secondsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.moveToButton).addComponent(this.bladeSetLabel).addComponent(this.bladeSetSpinner, -2, -1, -2).addComponent(this.toPositionLabel).addComponent(this.moveToSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeShutterButton).addComponent(this.openShutterButton)).addContainerGap()));
    }

    public double getExposureTime() {
        return ((Number)this.exposureTimeSpinner.getValue()).doubleValue();
    }

    public double getTargetPosition() {
        return ((Number)this.moveToSpinner.getValue()).doubleValue();
    }

    public ShutterSide getSide() {
        String value = (String)this.bladeSetSpinner.getValue();
        return value.equalsIgnoreCase("+X") ? ShutterSide.PLUSX : ShutterSide.MINUSX;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.takeExposureButton.setEnabled(enabled);
        this.exposureTimeSpinner.setEnabled(enabled);
        this.bladeSetSpinner.setEnabled(enabled);
        this.exposureTimeLabel.setEnabled(enabled);
        this.secondsLabel.setEnabled(enabled);
        this.bladeSetLabel.setEnabled(enabled);
        this.moveToButton.setEnabled(enabled);
        this.moveToSpinner.setEnabled(enabled);
        this.closeShutterButton.setEnabled(enabled);
        this.openShutterButton.setEnabled(enabled);
    }

    public void addTakeExposureActionListener(ActionListener l) {
        this.takeExposureButton.addActionListener(l);
    }

    public void removeTakeExposureActionListener(ActionListener l) {
        this.takeExposureButton.removeActionListener(l);
    }

    public void addMoveToActionListener(ActionListener l) {
        this.moveToButton.addActionListener(l);
    }

    public void removeMoveToActionListener(ActionListener l) {
        this.moveToButton.removeActionListener(l);
    }

    public void addCloseShutterActionListener(ActionListener l) {
        this.closeShutterButton.addActionListener(l);
    }

    public void removeCloseShutterActionListener(ActionListener l) {
        this.closeShutterButton.removeActionListener(l);
    }

    public void addOpenShutterActionListener(ActionListener l) {
        this.openShutterButton.addActionListener(l);
    }

    public void removeOpenShutterActionListener(ActionListener l) {
        this.openShutterButton.removeActionListener(l);
    }
}

