/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.lsst.ccs.subsystems.shutter.common.ShutterSide;

public class ShutterAssembly
extends JComponent {
    private Map<ShutterSide, Shutter> shutters = new EnumMap<ShutterSide, Shutter>(ShutterSide.class);

    public ShutterAssembly() {
        int height = 400;
        int width = 500;
        int shutterWidth = 100;
        Dimension dimension = new Dimension(500, 400);
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.shutters.put(ShutterSide.PLUSX, new Shutter(100, 400));
        this.shutters.put(ShutterSide.MINUSX, new Shutter(100, 400));
        this.shutters.get(ShutterSide.PLUSX).setShutterPosition(0.0f);
        this.shutters.get(ShutterSide.MINUSX).setShutterPosition(1.0f);
    }

    Shutter getShutter(ShutterSide side) {
        return this.shutters.get(side);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.addRenderingHints(hints);
        Arc2D.Float circle = new Arc2D.Float(100.0f, 50.0f, 300.0f, 300.0f, 0.0f, 360.0f, 1);
        g2.draw(circle);
        this.shutters.get(ShutterSide.MINUSX).paint(g2);
        AffineTransform saveAt = g2.getTransform();
        g2.translate(500, 0);
        g2.scale(-1.0, 1.0);
        this.shutters.get(ShutterSide.PLUSX).paint(g2);
        g2.setTransform(saveAt);
    }

    private static class Blade
    extends Rectangle2D.Float {
        Blade(int width, int height) {
            super(0.0f, 0.0f, width, height);
        }

        void setPosition(float x) {
            this.x = x;
        }

        float setPosition() {
            return this.x;
        }

        private void paint(Graphics2D g2) {
            g2.setColor(new Color(0.5f, 0.5f, 0.5f, 0.5f));
            g2.fill(this);
            g2.setColor(Color.BLACK);
            g2.draw(this);
        }
    }

    static class Shutter {
        private final List<Blade> blades = new ArrayList<Blade>();

        Shutter(int bladeWidth, int bladeHeight) {
            for (int i = 0; i < 3; ++i) {
                this.blades.add(new Blade(bladeWidth, bladeHeight));
            }
        }

        void setShutterPosition(float pos) {
            pos = Math.max(0.0f, Math.min(1.0f, pos));
            this.blades.get(0).setPosition(100.0f * pos);
            this.blades.get(1).setPosition(200.0f * pos);
            this.blades.get(2).setPosition(300.0f * pos);
        }

        float getShutterPosition() {
            return this.blades.get(0).setPosition() / 100.0f;
        }

        void paint(Graphics2D g2) {
            for (Blade blade : this.blades) {
                blade.paint(g2);
            }
        }
    }
}

