/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.lsst.ccs.subsystems.shutter.common.BladePosition;
import org.lsst.ccs.subsystems.shutter.common.HallTransition;
import org.lsst.ccs.subsystems.shutter.gui.EncoderReadOut;
import org.lsst.ccs.subsystems.shutter.gui.HallSensorHistory;
import org.lsst.ccs.subsystems.shutter.gui.MotorHistory;
import org.lsst.ccs.subsystems.shutter.gui.PlotPanelNew;
import org.lsst.ccs.subsystems.shutter.gui.ShutterAssembly;
import org.lsst.ccs.subsystems.shutter.sim.CubicSCurve;
import org.lsst.ccs.subsystems.shutter.sim.MotionProfile;
import org.lsst.ccs.subsystems.shutter.sim.MotorSimulator;
import org.lsst.ccs.subsystems.shutter.status.CloseShutterStatus;
import org.lsst.ccs.subsystems.shutter.status.MoveToPositionStatus;
import org.lsst.ccs.subsystems.shutter.status.MovementHistoryStatus;
import org.lsst.ccs.subsystems.shutter.status.OpenShutterStatus;
import org.lsst.ccs.subsystems.shutter.status.TakeExposureStatus;

public class ShutterDisplay
extends JPanel {
    private final ShutterAssembly assembly;
    private PlotPanelNew plotPanel;
    private List<MotorHistory> motorHistories = new ArrayList<MotorHistory>();
    private List<HallSensorHistory> hallSensorHistories = new ArrayList<HallSensorHistory>();
    private List<EncoderReadOut> encoderReadOuts = new ArrayList<EncoderReadOut>();
    private long timeOrigin = 0L;
    private static final double MOTOR_SAMPLING_INTERVAL = 0.05;

    public ShutterDisplay() {
        super(new BorderLayout());
        this.assembly = new ShutterAssembly();
        this.motorHistories.add(new MotorHistory());
        this.motorHistories.add(new MotorHistory());
        this.hallSensorHistories.add(new HallSensorHistory());
        this.hallSensorHistories.add(new HallSensorHistory());
        this.encoderReadOuts.add(new EncoderReadOut());
        this.encoderReadOuts.add(new EncoderReadOut());
        this.plotPanel = new PlotPanelNew(this.motorHistories, this.hallSensorHistories, this.encoderReadOuts);
        JSplitPane split = new JSplitPane(1);
        split.add(this.plotPanel);
        split.add(this.assembly);
        this.add((Component)split, "Center");
    }

    public void setBladeSetPositions(double pos0, double pos1) {
        this.assembly.getShutter(0).setShutterPosition((float)pos0);
        this.assembly.getShutter(1).setShutterPosition((float)pos1);
        this.assembly.setVisible(true);
        this.assembly.repaint();
    }

    public void hideAssembly() {
        this.assembly.setVisible(false);
        this.assembly.repaint();
    }

    private void startNewCommand(long t0, float tSpan) {
        for (int i = 0; i <= 1; ++i) {
            this.motorHistories.get(i).reset();
            this.hallSensorHistories.get(i).reset();
            this.encoderReadOuts.get(i).reset();
        }
        this.plotPanel.setTimePeriod(tSpan);
        this.timeOrigin = t0;
    }

    List<MotorHistory> getHistories() {
        return this.motorHistories;
    }

    public void showPredictedMoveTo(MoveToPositionStatus moveStat) {
        this.startNewCommand(moveStat.getStartTime(), (float)moveStat.getMoveTime());
        this.showPredictedMovement(moveStat.getIndex(), moveStat.getStartingPosition(), moveStat.getTargetPosition(), moveStat.getMoveTime(), 0L);
    }

    public void showPredictedMovement(int index, double startingPosition, double targetPosition, double moveTime, long startTime) {
        System.out.println("ShutterDisplay: startingPosition " + startingPosition + " targetPosition  " + targetPosition + " moveTimeSeconds " + moveTime);
        MotorSimulator motor = new MotorSimulator(startingPosition, 0.05, 1 + (int)Math.floor(moveTime / 0.05), startTime, (MotionProfile)new CubicSCurve(targetPosition - startingPosition, moveTime));
        this.motorHistories.get(index).addData(motor.getPositions());
    }

    void showPredictedExposure(TakeExposureStatus exposeStat) {
        float moveTime = (float)exposeStat.getMoveTime();
        float exposureTime = (float)exposeStat.getExposureTime();
        int firstMotorIndex = exposeStat.getfirstBladeSetIndex();
        int secondMotorIndex = 1 - firstMotorIndex;
        float firstStartingPosition = this.assembly.getShutter(firstMotorIndex).getShutterPosition();
        float secondStartingPosition = this.assembly.getShutter(secondMotorIndex).getShutterPosition();
        float firstTargetPosition = 0.0f;
        float secondTargetPosition = 1.0f;
        this.startNewCommand(exposeStat.getStartTime(), moveTime + exposureTime);
        this.showPredictedMovement(firstMotorIndex, firstStartingPosition, 0.0, moveTime, 0L);
        this.showPredictedMovement(secondMotorIndex, secondStartingPosition, 1.0, moveTime, (long)(1000000.0 * (double)exposureTime));
    }

    void showPredictedClose(CloseShutterStatus closeStat) {
        float moveTime = (float)closeStat.getMoveTime();
        int firstBladeSetIndex = closeStat.getfirstBladeSetIndex();
        int secondBladeSetIndex = 1 - firstBladeSetIndex;
        System.out.println("****** ShutterDisplay closeShutter: moveTime " + moveTime + " *********");
        this.startNewCommand(closeStat.getStartTime(), 2.0f * moveTime);
        this.showPredictedMovement(firstBladeSetIndex, this.assembly.getShutter(firstBladeSetIndex).getShutterPosition(), 0.0, moveTime, 0L);
        this.showPredictedMovement(secondBladeSetIndex, this.assembly.getShutter(secondBladeSetIndex).getShutterPosition(), 1.0, moveTime, (long)(1000000.0 * (double)moveTime));
    }

    void showPredictedOpen(OpenShutterStatus openStat) {
        float moveTime = (float)openStat.getMoveTime();
        int firstBladeSetIndex = openStat.getfirstBladeSetIndex();
        int secondBladeSetIndex = 1 - firstBladeSetIndex;
        System.out.println("****** ShutterDisplay openShutter: moveTime " + moveTime + " *********");
        this.startNewCommand(openStat.getStartTime(), 2.0f * moveTime);
        this.showPredictedMovement(firstBladeSetIndex, this.assembly.getShutter(firstBladeSetIndex).getShutterPosition(), 0.0, moveTime, 0L);
        this.showPredictedMovement(secondBladeSetIndex, this.assembly.getShutter(secondBladeSetIndex).getShutterPosition(), 0.0, moveTime, (long)(1000000.0 * (double)moveTime));
    }

    void showActualMovement(MovementHistoryStatus moveStat) {
        System.out.println("****** showActualMovement *********");
        int index = moveStat.getIndex();
        this.showActualMotorPositions(index, moveStat.getHistory().getPositions());
        this.showActualHallTransitions(index, moveStat.getHistory().getHallTransitions());
    }

    private void showActualMotorPositions(int motorIndex, List<BladePosition> pos) {
        System.out.println("********** showActualMotorPositions " + pos.size() + " ************");
        this.assembly.getShutter(motorIndex).setShutterPosition((float)pos.get(pos.size() - 1).getRelPosition());
        this.assembly.repaint();
        this.encoderReadOuts.get(motorIndex).addData(pos, this.timeOrigin);
        for (BladePosition p : pos) {
            System.out.println("UI : set " + motorIndex + " Time" + p.getTime() + " position " + p.getRelPosition());
        }
    }

    void showActualHallTransitions(int motorIndex, List<HallTransition> trans) {
        System.out.println("************ showActualHallTransitions " + trans.size() + " ************");
        this.hallSensorHistories.get(motorIndex).addData(trans, this.timeOrigin);
        for (HallTransition h : trans) {
            System.out.println("UI: set " + motorIndex + " Time " + h.getTransitionTime() + " position " + h.getPosition());
            System.out.println("UI: set " + motorIndex + " ID " + h.getSensorId() + " State " + h.isOpen() + " retracting " + h.isReverse());
        }
    }
}

