/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.gui;

import data.DiscretePlotData;
import data.MetaData;
import data.MutablePlotData;
import data.PlotDataListener;
import data.SuggestedRange;
import java.util.ArrayList;
import java.util.List;
import org.freehep.util.Value;
import org.lsst.ccs.subsystems.shutter.common.BladePosition;
import util.ListenerList;

public class EncoderReadOut
implements DiscretePlotData,
MutablePlotData {
    private final List<readOut> history = new ArrayList<readOut>();
    private final ListenerList<PlotDataListener> listeners = new ListenerList();
    private final String[] names = new String[]{"Time", "Position"};
    private static double ERROR = 0.02;

    public void EncoderReadOut() {
    }

    public void reset() {
        this.history.clear();
        this.firePlotDataChanged();
    }

    public void addData(List<BladePosition> pos, long timeOrigin) {
        for (BladePosition p : pos) {
            double t = (double)(p.getTime() - timeOrigin) / 1000000.0;
            System.out.println("EncoderReadOut :  Relative time " + t + " smeared position " + p.getRelPosition());
            this.history.add(new readOut(t, p.getRelPosition(), ERROR));
        }
        this.firePlotDataChanged();
    }

    public int getNPoints() {
        return this.history.size();
    }

    public int getNDimensions() {
        return this.names.length;
    }

    public String names(int index) {
        return this.names[index];
    }

    public Class types(int index) {
        return Double.TYPE;
    }

    public void getValue(Value value, int dim, int index) {
        readOut mp = this.history.get(index);
        switch (dim) {
            case 0: {
                value.set(mp.getTime());
                break;
            }
            case 1: {
                value.set(mp.getPosition());
                break;
            }
            case 2: {
                value.set(mp.getError());
            }
        }
    }

    public MetaData getMetaData() {
        return null;
    }

    public String getTitle() {
        return "Motor Readout";
    }

    public SuggestedRange getSuggestedRange() {
        return null;
    }

    public void addPlotDataListener(PlotDataListener listener) {
        this.listeners.addListener((Object)listener);
    }

    public void removePlotDataListener(PlotDataListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    private void firePlotDataChanged() {
        if (!this.listeners.isEmpty()) {
            for (PlotDataListener l : this.listeners.getListeners()) {
                l.dataChanged();
            }
        }
    }

    public Object lock() {
        return this.history;
    }

    private static class readOut {
        private final double time;
        private final double position;
        private final double error;

        public readOut(double time, double position, double error) {
            this.time = time;
            this.position = position;
            this.error = error;
        }

        public double getTime() {
            return this.time;
        }

        public double getPosition() {
            return this.position;
        }

        public double getError() {
            return this.error;
        }
    }
}

