package org.lsst.ccs.subsystems.shutter.gui;

import java.awt.event.ActionListener;

/**
 * Provides various controls for the shutter subsystem. This class is not thread safe
 * and its methods should be called from the Swing event dispatch thread, via invokeLater() for example.
 * @author tonyj
 * @author tether
 */
public class ShutterControlPanel extends javax.swing.JPanel {

    /** Creates new form ShutterControlPanel */
    public ShutterControlPanel() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        takeExposureButton = new javax.swing.JButton();
        exposureTimeLabel = new javax.swing.JLabel();
        exposureTimeSpinner = new javax.swing.JSpinner();
        secondsLabel = new javax.swing.JLabel();
        moveToButton = new javax.swing.JButton();
        moveToSpinner = new javax.swing.JSpinner();
        bladeSetSpinner = new javax.swing.JSpinner();
        bladeSetLabel = new javax.swing.JLabel();
        toPositionLabel = new javax.swing.JLabel();
        closeShutterButton = new javax.swing.JButton();
        openShutterButton = new javax.swing.JButton();

        takeExposureButton.setText("Take Exposure");

        exposureTimeLabel.setText("Exposure Time:");

        exposureTimeSpinner.setModel(new javax.swing.SpinnerNumberModel(Float.valueOf(5.0f), Float.valueOf(1.0f), Float.valueOf(20.0f), Float.valueOf(0.1f)));

        secondsLabel.setText("seconds");

        moveToButton.setText("Move");

        moveToSpinner.setModel(new javax.swing.SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.05f)));
        moveToSpinner.setMinimumSize(new java.awt.Dimension(50, 18));

        bladeSetSpinner.setModel(new javax.swing.SpinnerNumberModel(0, 0, 1, 1));

        bladeSetLabel.setText("Blade set:");

        toPositionLabel.setText("to position");

        closeShutterButton.setText("Close Shutter");

        openShutterButton.setText("Open Shutter");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(takeExposureButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(exposureTimeLabel)
                        .addGap(4, 4, 4)
                        .addComponent(exposureTimeSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(secondsLabel))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(moveToButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(bladeSetLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(bladeSetSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(toPositionLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(moveToSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(closeShutterButton)
                        .addGap(18, 18, 18)
                        .addComponent(openShutterButton)))
                .addContainerGap(89, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(takeExposureButton)
                    .addComponent(exposureTimeLabel)
                    .addComponent(exposureTimeSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(secondsLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(moveToButton)
                    .addComponent(bladeSetLabel)
                    .addComponent(bladeSetSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(toPositionLabel)
                    .addComponent(moveToSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(closeShutterButton)
                    .addComponent(openShutterButton))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    public double getExposureTime() {
        return ((Number) exposureTimeSpinner.getValue()).doubleValue();
    }

    public double getTargetPosition() {
        return ((Number) moveToSpinner.getValue()).doubleValue();
    }
    public int getBladeSetIndex() {
        return ((Number) bladeSetSpinner.getValue()).intValue();
    }
    @Override
    public void setEnabled(boolean enabled) {
        takeExposureButton.setEnabled(enabled);
        exposureTimeSpinner.setEnabled(enabled);
        bladeSetSpinner.setEnabled(enabled);
        exposureTimeLabel.setEnabled(enabled);
        secondsLabel.setEnabled(enabled);
        bladeSetLabel.setEnabled(enabled);
        moveToButton.setEnabled(enabled);
        moveToSpinner.setEnabled(enabled);
        closeShutterButton.setEnabled(enabled);
        openShutterButton.setEnabled(enabled);
    }

    public void addTakeExposureActionListener(ActionListener l) {
        takeExposureButton.addActionListener(l);
    }

    public void removeTakeExposureActionListener(ActionListener l) {
        takeExposureButton.removeActionListener(l);
    }
    public void addMoveToActionListener(ActionListener l) {
        moveToButton.addActionListener(l);
    }

    public void removeMoveToActionListener(ActionListener l) {
        moveToButton.removeActionListener(l);
    }

    public void addCloseShutterActionListener(ActionListener l) {
        closeShutterButton.addActionListener(l);
    }

    public void removeCloseShutterActionListener(ActionListener l) {
        closeShutterButton.removeActionListener(l);
    }

    public void addOpenShutterActionListener(ActionListener l) {
        openShutterButton.addActionListener(l);
    }

    public void removeOpenShutterActionListener(ActionListener l) {
        openShutterButton.removeActionListener(l);
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel bladeSetLabel;
    private javax.swing.JSpinner bladeSetSpinner;
    private javax.swing.JButton closeShutterButton;
    private javax.swing.JLabel exposureTimeLabel;
    private javax.swing.JSpinner exposureTimeSpinner;
    private javax.swing.JButton moveToButton;
    private javax.swing.JSpinner moveToSpinner;
    private javax.swing.JButton openShutterButton;
    private javax.swing.JLabel secondsLabel;
    private javax.swing.JButton takeExposureButton;
    private javax.swing.JLabel toPositionLabel;
    // End of variables declaration//GEN-END:variables

}
