package org.lsst.ccs.subsystems.shutter.gui;

import data.PlotDataListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plotter.Axis.AxisPosition;
import plotter.*;

/**
 * Displays plots of the predicted and actual motions of the shutter blade sets, along with
 * actual Hall transitions. This class is not thread safe and its methods should be called from
 * the Swing event dispatch thread.
 * @author tonyj
 * @author tether
 */
public class PlotPanelNew extends JPanel {

    private final LinearAxisModel yAxisModel;

    PlotPanelNew(List<MotorHistory> motorHistories, 
                  List<HallSensorHistory> hallSensorHistories,
                  List<EncoderReadOut> encoderReadOuts) {

        super(new BorderLayout());

        JPanel plotPanel = new JPanel(new PlotLayout());
        plotPanel.setPreferredSize(new Dimension(500, 300));
        ContinuousAxisModel xAxisModel = new LinearAxisModel(-1.1, 1.1);
        yAxisModel = new LinearAxisModel(0, 5);
        Axis xAxis = new Axis(xAxisModel, AxisPosition.LEFT);
        Axis yAxis = new Axis(yAxisModel, AxisPosition.BOTTOM);

        DataArea da = new DataArea(yAxis, xAxis);

        LineChartOverlay acceleration = new LineChartOverlay("Pred acc", motorHistories.get(0), 0, 1, yAxisModel, xAxisModel);
        da.add(acceleration);
        LineChartOverlay velocity = new LineChartOverlay("Pred vel", motorHistories.get(0), 0, 2, yAxisModel, xAxisModel);
        velocity.setLineColor(Color.BLUE);
        da.add(velocity);
        LineChartOverlay position = new LineChartOverlay("Pred pos", motorHistories.get(0), 0, 3, yAxisModel, xAxisModel);
        position.setLineColor(Color.GREEN);
        da.add(position);

        DataPointChartOverlay hallSensors = new DataPointChartOverlay("Hall transitions",hallSensorHistories.get(0), 0, 1, -1, -1, 2, 2, yAxisModel, xAxisModel);
        hallSensors.setLineColor(Color.yellow);
        da.add(hallSensors);
        DataPointChartOverlay readOuts = new DataPointChartOverlay("Encoder readouts", encoderReadOuts.get(0), 0, 1, -1, -1, 2, 2, yAxisModel, xAxisModel);
        readOuts.setLineColor(Color.BLACK);
        da.add(readOuts);

        KeyPanel keyPanel1 = new KeyPanel("Blade set 0");
        keyPanel1.add(acceleration);
        keyPanel1.add(velocity);
        keyPanel1.add(position);
        keyPanel1.add(hallSensors);
        keyPanel1.add(readOuts);

        LineChartOverlay acceleration2 = new LineChartOverlay("Pred acc", motorHistories.get(1), 0, 1, yAxisModel, xAxisModel);
        acceleration2.setLineColor(Color.ORANGE);
        da.add(acceleration2);
        LineChartOverlay velocity2 = new LineChartOverlay("Pred vel", motorHistories.get(1), 0, 2, yAxisModel, xAxisModel);
        velocity2.setLineColor(Color.CYAN);
        da.add(velocity2);
        LineChartOverlay position2 = new LineChartOverlay("Pred pos", motorHistories.get(1), 0, 3, yAxisModel, xAxisModel);
        position2.setLineColor(Color.MAGENTA);
        da.add(position2);

        DataPointChartOverlay hallSensors2 = new DataPointChartOverlay("Hall transitions",hallSensorHistories.get(1), 0, 1, -1, -1, 2, 2, yAxisModel, xAxisModel);
        hallSensors2.setLineColor(Color.PINK);
        da.add(hallSensors2);
        DataPointChartOverlay readOuts2 = new DataPointChartOverlay("Encoder readouts", encoderReadOuts.get(1), 0, 1, -1, -1, 2, 2, yAxisModel, xAxisModel);
        readOuts2.setLineColor(Color.GRAY);
        da.add(readOuts2);


        plotPanel.add(xAxis);
        plotPanel.add(yAxis);
        plotPanel.add(da);

        KeyPanel keyPanel2 = new KeyPanel("Blade set 1");
        keyPanel2.add(acceleration2);
        keyPanel2.add(velocity2);
        keyPanel2.add(position2);
        keyPanel2.add(hallSensors2);
        keyPanel2.add(readOuts2);


        JPanel key = new JPanel(new BorderLayout());
        key.add(BorderLayout.NORTH, keyPanel1);
        key.add(BorderLayout.SOUTH, keyPanel2);
        key.setBorder(BorderFactory.createTitledBorder("Key"));

        add(plotPanel,BorderLayout.CENTER);
        add(key,BorderLayout.SOUTH);

        motorHistories.get(0).addPlotDataListener(new PlotDataListener() {

            @Override
            public void dataChanged() {
                repaint();
            }
        });
        motorHistories.get(1).addPlotDataListener(new PlotDataListener() {

            @Override
            public void dataChanged() {
                repaint();
            }
        });

        hallSensorHistories.get(0).addPlotDataListener(new PlotDataListener() {

            @Override
            public void dataChanged() {
                repaint();
            }
        });
        hallSensorHistories.get(1).addPlotDataListener(new PlotDataListener() {

            @Override
            public void dataChanged() {
                repaint();
            }
        });

        encoderReadOuts.get(0).addPlotDataListener(new PlotDataListener() {

            @Override
            public void dataChanged() {
                repaint();
            }
        });
        encoderReadOuts.get(1).addPlotDataListener(new PlotDataListener() {

            @Override
            public void dataChanged() {
                repaint();
            }
        });

    }

    void setTimePeriod(float time) {
        yAxisModel.setMax(time);
        repaint();
    }

    private static class KeyPanel extends JPanel {

        KeyPanel(String title) {
            super(new FlowLayout());
            add(new JLabel(title));
        }

        private void add(LineChartOverlay overlay) {
            JLabel label = new JLabel(overlay.getTitle());
            label.setIcon(overlay.getKeyIcon());
            add(label);
        }

        private void add(DataPointChartOverlay overlay) {
            JLabel label = new JLabel(overlay.getTitle());
            label.setIcon(overlay.getKeyIcon());
            add(label);
        }
    }

}


