/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.gui;

import data.DiscretePlotData;
import data.MetaData;
import data.MutablePlotData;
import data.PlotDataListener;
import data.SuggestedRange;
import java.util.ArrayList;
import java.util.List;
import org.freehep.util.Value;
import util.ListenerList;

public class MotorHistory
implements DiscretePlotData,
MutablePlotData {
    private final List<MotorSpeed> history = new ArrayList<MotorSpeed>();
    private final ListenerList<PlotDataListener> listeners = new ListenerList();
    private final String[] names = new String[]{"Time", "Acceleration", "Velocity", "Position"};
    private long startTime = 0L;

    public void MotorHistory() {
    }

    public void reset() {
        this.startTime = 0L;
        this.history.clear();
        this.firePlotDataChanged();
    }

    public void addData(long time, double acceleration, double velocity, double position) {
        if (this.startTime == 0L) {
            this.startTime = time;
        }
        this.history.add(new MotorSpeed((double)(time - this.startTime) / 1000.0, acceleration, velocity, position));
        this.firePlotDataChanged();
    }

    public int getNPoints() {
        return this.history.size();
    }

    public int getNDimensions() {
        return this.names.length;
    }

    public String names(int index) {
        return this.names[index];
    }

    public Class types(int index) {
        return Double.TYPE;
    }

    public void getValue(Value value, int dim, int index) {
        MotorSpeed speed = this.history.get(index);
        switch (dim) {
            case 0: {
                value.set(speed.getDate());
                break;
            }
            case 1: {
                value.set(speed.getAcceleration());
                break;
            }
            case 2: {
                value.set(speed.getVelocity());
                break;
            }
            case 3: {
                value.set(speed.getPosition());
            }
        }
    }

    public MetaData getMetaData() {
        return null;
    }

    public String getTitle() {
        return "Motor History";
    }

    public SuggestedRange getSuggestedRange() {
        return null;
    }

    public void addPlotDataListener(PlotDataListener listener) {
        this.listeners.addListener((Object)listener);
    }

    public void removePlotDataListener(PlotDataListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    private void firePlotDataChanged() {
        if (!this.listeners.isEmpty()) {
            for (PlotDataListener l : this.listeners.getListeners()) {
                l.dataChanged();
            }
        }
    }

    public Object lock() {
        return this.history;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    private static class MotorSpeed {
        private double date;
        private double acceleration;
        private double velocity;
        private double position;

        public MotorSpeed(double date, double acceleration, double velocity, double position) {
            this.date = date;
            this.acceleration = acceleration;
            this.velocity = velocity;
            this.position = position;
        }

        public double getAcceleration() {
            return this.acceleration;
        }

        public double getDate() {
            return this.date;
        }

        public double getPosition() {
            return this.position;
        }

        public double getVelocity() {
            return this.velocity;
        }
    }
}

