/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.gui;

import data.DiscretePlotData;
import data.MetaData;
import data.MutablePlotData;
import data.PlotDataListener;
import data.SuggestedRange;
import java.util.ArrayList;
import java.util.List;
import org.freehep.util.Value;
import util.ListenerList;

public class HallSensorHistory
implements DiscretePlotData,
MutablePlotData {
    private final List<HallTransition> history = new ArrayList<HallTransition>();
    private final ListenerList<PlotDataListener> listeners = new ListenerList();
    private final String[] names = new String[]{"Time", "Position"};
    private static double ERROR = 0.02;
    private double startTime = 0.0;
    private double startPosition = 0.0;
    private long t0 = 0L;
    private double p0;

    public void HallSensorHistory() {
    }

    public void reset() {
        this.startTime = 0.0;
        this.t0 = 0L;
        this.history.clear();
        this.firePlotDataChanged();
    }

    public void addData(long time, double position) {
        if (this.startTime == 0.0) {
            if (this.t0 == 0L) {
                this.t0 = time;
                this.p0 = position;
                return;
            }
            this.startTime = (double)this.t0 - (this.p0 - this.startPosition) * (double)(time - this.t0) / (position - this.p0);
            this.history.add(new HallTransition(((double)this.t0 - this.startTime) / 1000.0, this.p0, ERROR));
        }
        this.history.add(new HallTransition(((double)time - this.startTime) / 1000.0, position, ERROR));
        this.firePlotDataChanged();
    }

    public int getNPoints() {
        return this.history.size();
    }

    public int getNDimensions() {
        return this.names.length;
    }

    public String names(int index) {
        return this.names[index];
    }

    public Class types(int index) {
        return Double.TYPE;
    }

    public void getValue(Value value, int dim, int index) {
        HallTransition transition = this.history.get(index);
        switch (dim) {
            case 0: {
                value.set(transition.getTime());
                break;
            }
            case 1: {
                value.set(transition.getPosition());
                break;
            }
            case 2: {
                value.set(transition.getError());
            }
        }
    }

    public MetaData getMetaData() {
        return null;
    }

    public String getTitle() {
        return "Hall Sensor History";
    }

    public SuggestedRange getSuggestedRange() {
        return null;
    }

    public void addPlotDataListener(PlotDataListener listener) {
        this.listeners.addListener((Object)listener);
    }

    public void removePlotDataListener(PlotDataListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    private void firePlotDataChanged() {
        if (!this.listeners.isEmpty()) {
            for (PlotDataListener l : this.listeners.getListeners()) {
                l.dataChanged();
            }
        }
    }

    public Object lock() {
        return this.history;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    public void setStartPosition(double startPosition) {
        this.startPosition = startPosition;
    }

    private static class HallTransition {
        private double time;
        private double position;
        private double error;

        public HallTransition(double time, double position, double error) {
            this.time = time;
            this.position = position;
            this.error = error;
        }

        public double getTime() {
            return this.time;
        }

        public double getPosition() {
            return this.position;
        }

        public double getError() {
            return this.error;
        }
    }
}

