package org.lsst.ccs.subsystems.shutter.gui;

import javax.swing.JComponent;
import org.lsst.ccs.subsystems.shutter.status.*;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.ModuleInvokerCommand;

/**
 *
 * @author azemoon
 */
public class ShutterGUISubsystem extends Subsystem {

    static final String shutter_dest = "ccs-shutter";

    private MessagingFactory mfac;
    ShutterDisplay display;
    ShutterControlPanel control;

    public ShutterGUISubsystem() {
        display = new ShutterDisplay();
        control = new ShutterControlPanel();    
}
    
    public static void main(String[] args) {
        
        System.setProperty("java.naming.factory.initial", "com.sun.enterprise.naming.SerialInitContextFactory");
        System.setProperty("java.naming.factory.url.pkgs", "com.sun.enterprise.naming");
        System.setProperty("java.naming.factory.state", "com.sun.corba.ee.impl.presentation.rmi.JNDIStateFactoryImpl");
        System.setProperty("org.omg.CORBA.ORBInitialHost", "localhost");
        System.setProperty("org.omg.CORBA.ORBInitialPort", "3700");
        
     // Properties props = FrameworkUtils.loadProperties(FrameworkUtils.getDefaultJndiProperties(),RefrigGUISubsystem.class.getClass(),"jndi.properties");


        ShutterGUISubsystem shutterGUI = new ShutterGUISubsystem();
        shutterGUI.initGui();
        JFrame frame = new JFrame("Shutter GUI demo");
        frame.getRootPane().setDoubleBuffered(true);
        frame.getContentPane().add(shutterGUI.getDisplayComponent(),BorderLayout.CENTER);
        frame.getContentPane().add(shutterGUI.getControlsComponent(),BorderLayout.SOUTH);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setResizable(true);
        frame.pack();
        frame.setVisible(true);
    }

    
    public void initGui() {
        setUpActionListeners(control, display);
        setName("ShutterGUIModule");
        mfac = MessagingFactory.getInstance().forSubsystem(getName());
        setListenToStatus(true);
        setStatusBroadcastPeriod(0);
        start();
    }
    
    
    public JComponent getDisplayComponent() {
        return display;
    }
    public JComponent getControlsComponent() {
        return control;
    }
    
    
    public void sendMoveToPosition(int index, float targetPosition, float moveTimeSeconds) {
        Integer arg1 = index;
        Float arg2 = targetPosition;
        Float arg3 = moveTimeSeconds;
        String command = "moveToPosition";

        ModuleInvokerCommand cmd = new ModuleInvokerCommand(command, arg1, arg2, arg3);
        cmd.setDestination(shutter_dest);
        mfac.sendCommand(cmd);
    }

    public void sendTakeImage(float moveTimeSeconds, float exposureTimeSeconds) {
        Float arg1 = moveTimeSeconds;
        Float arg2 = exposureTimeSeconds;
        String command = "takeImage";

        ModuleInvokerCommand cmd = new ModuleInvokerCommand(command, arg1, arg2);
        cmd.setDestination(shutter_dest);
        mfac.sendCommand(cmd);
    }

    public void sendCloseShutter() {
        ModuleInvokerCommand cmd = new ModuleInvokerCommand("closeShutter");
        cmd.setDestination(shutter_dest);
        mfac.sendCommand(cmd);
    }

    @Override
    public void onStatus(BusMessage s) {
        if( s instanceof MovementStatus) {
            System.out.println("~_~_~_~_~_~s instanceof MovementStatus_~_~_~_~_~_~_~_");
            display.recordMovement((MovementStatus) s);
        } else if( s instanceof HallTransitionStatus) {
            System.out.println("~_~_~_~_~_~_s instanceof HallTransitionStatus~_~_~_~_~_~_~_");
            display.recordHallTransition( (HallTransitionStatus) s);
        } else if( s instanceof MoveBladeSetStatus) {
            System.out.println("~_~_~_~_~_~_~s instanceof MoveBladeSetStatus_~_~_~_~_~_~_");
            control.setEnabled(false);
            display.moveToPosition( (MoveBladeSetStatus) s);
        } else if ( s instanceof TakeImageStatus) {
            System.out.println("~_~_~_~_~_~_s instanceof TakeImageStatus~_~_~_~_~_~_~_");
            control.setEnabled(false);
            display.takeImage((TakeImageStatus) s);
        } else if ( s instanceof ReadyForActionStatus) {
            System.out.println("~_~_~_~_~_~_s instanceof ReadyForActionStatus~_~_~_~_~_~_~_");
            ReadyForActionStatus status = (ReadyForActionStatus) s;
            control.setEnabled(status.isReadyForAction());
        } else if ( s instanceof CloseShutterStatus) {
            System.out.println("~_~_~_~_~_~_s instanceof CloseShutterStatus~_~_~_~_~_~_~_");
            control.setEnabled(false);
            display.closeShutter((CloseShutterStatus) s);
        }

    }
    /**
     * @param control
     * @param display
     */
        public void setUpActionListeners(final ShutterControlPanel control, final ShutterDisplay display) {
        control.addTakeImageActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
               //Publish command: takeImage control.getMovementTime(), control.getExposureTime()
                System.out.println("ShutterGUI: sending TakeImage command");
                sendTakeImage(control.getMovementTime(), control.getExposureTime());
                System.out.println("ShutterGUI: sent TakeImage command");
            }
        });
        
        control.addMoveToActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
               //Publish command: moveToPosition control.getBladeSetIndex(), control.getTargetPosition(), control.getMovementTime()
                System.out.println("ShutterGUI: sending MoveToPosition command");
                sendMoveToPosition(control.getBladeSetIndex(), control.getTargetPosition(), control.getMovementTime());
                System.out.println("ShutterGUI: sent MoveToPosition command");
            }
        });

        control.addCloseShutterActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
               //Publish command: closeShutter
                System.out.println("ShutterGUI: sending CloseShutter command");
                sendCloseShutter();
                System.out.println("ShutterGUI: sent CloseShutter command");
            }
        });

        display.addChangeListener(new ChangeListener() {

            @Override
            public void stateChanged(ChangeEvent e) {
                //TODO: make sure ShutterSimulator is finished as well.
                control.setEnabled(!display.isInMotion());
            }
        });
    }
}
