/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.sim.test;

import java.time.Duration;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.shutter.sim.CubicSCurve;
import org.lsst.ccs.subsystem.shutter.sim.MotionProfile;
import org.lsst.ccs.subsystem.shutter.sim.PredictedPosition;
import org.lsst.ccs.subsystem.shutter.sim.PredictedTrajectory;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class MotorSimulatorTest {
    public static final double[] MOVE_TIME = new double[]{0.73, 1.0, 2.0};
    public static final double DISTANCE = 1.0;
    public static final double START_POSITION = 0.0;
    public static final int NUM_SAMPLES = 41;
    private static final String FMT = "%+8.4f  %+8.4f  %+8.4f";
    private static final CCSTimeStamp T0 = CCSTimeStamp.currentTime();

    private static String format(double a, double b, double c) {
        return String.format(FMT, a, b, c);
    }

    public static PredictedTrajectory standardTrajectory(double moveTime) {
        Duration dt = Duration.ofNanos((long)(1.0E9 * moveTime / 40.0));
        CubicSCurve profile = new CubicSCurve(1.0, moveTime);
        return new PredictedTrajectory(0.0, T0, dt, 41, (MotionProfile)profile);
    }

    @Test
    public void checkSCurveMotion() {
        for (double moveTime : MOVE_TIME) {
            PredictedTrajectory sim = MotorSimulatorTest.standardTrajectory(moveTime);
            for (PredictedPosition pos : sim.getPositions()) {
                CubicSCurve profile = new CubicSCurve(1.0, moveTime);
                String motor = MotorSimulatorTest.format(pos.getPosition(), pos.getVelocity(), pos.getAcceleration());
                double t = (double)pos.timeDiff(T0).toNanos() * 1.0E-9;
                String prof = MotorSimulatorTest.format(profile.distance(t), profile.velocity(t), profile.acceleration(t));
                Assert.assertEquals((String)("Failed for move time = " + moveTime), (Object)prof, (Object)motor);
            }
        }
    }
}

