package org.lsst.ccs.subsystem.shutter.common;

import java.time.Duration;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

/**
 * For objects that have a natural time ordering using CCS timestamps.
 * @author tether
 */
public interface TimeOrdered extends Comparable<TimeOrdered> {

    CCSTimeStamp getTime();

    @Override
    default int compareTo(final TimeOrdered other) {
        return getTime().getTAIInstant().compareTo(other.getTime().getTAIInstant());
    }

    /**
     * Calculates the time difference between {@code this.getTime()} and a reference
     * timestamp.
     * @param ref The reference timestamp.
     * @return The time difference as a {@code Duration} (may be negative or zero).
     */
    default Duration timeDiff(final CCSTimeStamp ref) {
        return Duration.between(ref.getTAIInstant(), getTime().getTAIInstant());
    }

    /**
     * Calculates the time difference between {@code this.getTime()} and a reference
     * {@code TimeOrdered object}.
     * @param ref The object whose time is used as a reference..
     * @return The time difference as a {@code Duration} (may be negative or zero).
     */

    default Duration timeDiff(final TimeOrdered ref) {
        return timeDiff(ref.getTime());
    }

}
