package org.lsst.ccs.subsystem.shutter.common;

/**
 * Describes the internal state of the CCS worker subsystem used to control the shutter. Reported
 * as part of the state bundle of the running subsystem. Only non-composite states
 * have members, composite states show up in the descriptions. For example, a state
 * Foo which is a sub-state of the composite state Bar will have the description
 * "Foo in Bar".
 * @author tether
 */
public enum SoftwareState {
    /** Waiting for the shutter controller to enter its Still or Disabled state after a reset. */
    SYNCHRONIZING("Synchronizing"),
    
    /** Lost contact with the shutter controller or timed out in the Synchronizing state. */
    SYNC_ERROR("SyncError"),
    
    /** Hardware protection logic has disabled operation of the shutter. */
    DISABLED("Disabled in InSync"),
    
    /** Blade sets are motionless (Maint mode). */
    STILL("Still in Maint in Enabled in InSync"),
    
    /** A blade set is moving in response to a single-axis motion command (Maint mode). */
    MOVING("Moving in Maint in Enabled in InSync"),
    
    /** The shutter controller is performing a calibration (Maint mode). */
    CALIBRATING("Calibrating in Maint in Enabled in InSync"),
    
    /** The first blade set is moving to its center position (Maint mode). */
    CENTERING1("Centering1 in Maint in Enabled in InSync"),
    
    /** The second blade set is moving to its center position (Maint mode). */
    CENTERING2("Centering2 in Maint in Enabled in InSync"),
    
    /** The shutter is closed (Prod mode). */
    CLOSED("Closed in Prod in Enabled in InSync"),
    
    /** The shutter is opening (Prod mode). */
    OPENING("Opening in Prod in Enabled in InSync"),
    
    /** The shutter is performing a traveling-slit exposure (Prod mode).*/
    TRAVELING("Traveling in Prod in Enabled in InSync"),
    
    /** The shutter is open (Prod mode). */
    OPENED("Opened in Prod in Enabled in InSync"),
    
    /** The shutter is closing (Prod mode). */
    CLOSING("Closing in Prod in Enabled in InSync");

    private final String description;
    
    SoftwareState(final String description) {this.description = description;}
    
    public String getDescription() {return description;}
}
