package org.lsst.ccs.subsystem.shutter.common;

/**
 * Descriptions of the current state of the shutter as reported to OCS, regardless of the internal state of
 * the state machine used by the subsystem to control the shutter. These are the states used in the
 * state bundle for the subsystem.
 * @author tether
 */
public enum PhysicalState {
    /** Fully closed. One blade set is fully retracted and the other is fully extended. */
    CLOSED,

    /** On the way from being closed to opened. One blade set is retracting. */
    OPENING,

    /** Fully opened. Both blade sets are fully retracted. */
    OPENED,

    /** Traveling slit. Due to a very short exposure time we started closing the
     *  shutter before it had become fully opened. Both blade sets are in
     *  motion, one retracting and the other extending.
    */
    TRAVELING,

    /** On the way from being fully opened or traveling to being fully closed.
     *  One blade set is fully retracted and the other is still being extended.
     */
    CLOSING,

    /** Prepared for power-off. Both blade sets are half-extended. */
    CENTERED,

    /** Non-standard blade set motion. A blade set is being moved in some way other than
     * with the subsystem commands {@code closeShutter()}, {@code openShutter()} or
     * {@code takeExposure()}. Covers Hall calibration and other
     * engineering-mode activities.
     */
    ENG_MOVING,

    /** The blade set positions are either unknown or don't fit into any of the
     * other categories.
     */
    OTHER;
}
