/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.sim.test;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.subsystem.shutter.sim.CubicSCurve;

public class PrototypeSCurveTest {
    private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();
    private PrintStream oldOut;
    private static final String correctOutput = "Time      Distance  Velocity  Accel     inv Dist\n--------  --------  --------  --------  --------\n +0.0000   +0.0000   +0.0000   +0.0000   +0.0000\n +0.0500   +0.0001   +0.0050   +0.2000   +0.0500\n +0.1000   +0.0007   +0.0200   +0.4000   +0.1000\n +0.1500   +0.0023   +0.0450   +0.6000   +0.1500\n +0.2000   +0.0053   +0.0800   +0.8000   +0.2000\n +0.2500   +0.0104   +0.1250   +1.0000   +0.2500\n +0.3000   +0.0180   +0.1800   +1.2000   +0.3000\n +0.3500   +0.0286   +0.2450   +1.4000   +0.3500\n +0.4000   +0.0427   +0.3200   +1.6000   +0.4000\n +0.4500   +0.0608   +0.4050   +1.8000   +0.4500\n +0.5000   +0.0833   +0.5000   +2.0000   +0.5000\n +0.5500   +0.1108   +0.5950   +1.8000   +0.5500\n +0.6000   +0.1427   +0.6800   +1.6000   +0.6000\n +0.6500   +0.1786   +0.7550   +1.4000   +0.6500\n +0.7000   +0.2180   +0.8200   +1.2000   +0.7000\n +0.7500   +0.2604   +0.8750   +1.0000   +0.7500\n +0.8000   +0.3053   +0.9200   +0.8000   +0.8000\n +0.8500   +0.3522   +0.9550   +0.6000   +0.8500\n +0.9000   +0.4007   +0.9800   +0.4000   +0.9000\n +0.9500   +0.4501   +0.9950   +0.2000   +0.9500\n +1.0000   +0.5000   +1.0000   +0.0000   +1.0000\n +1.0500   +0.5499   +0.9950   -0.2000   +1.0500\n +1.1000   +0.5993   +0.9800   -0.4000   +1.1000\n +1.1500   +0.6477   +0.9550   -0.6000   +1.1500\n +1.2000   +0.6947   +0.9200   -0.8000   +1.2000\n +1.2500   +0.7396   +0.8750   -1.0000   +1.2500\n +1.3000   +0.7820   +0.8200   -1.2000   +1.3000\n +1.3500   +0.8214   +0.7550   -1.4000   +1.3500\n +1.4000   +0.8573   +0.6800   -1.6000   +1.4000\n +1.4500   +0.8893   +0.5950   -1.8000   +1.4500\n +1.5000   +0.9167   +0.5000   -2.0000   +1.5000\n +1.5500   +0.9393   +0.4050   -1.8000   +1.5500\n +1.6000   +0.9573   +0.3200   -1.6000   +1.6000\n +1.6500   +0.9714   +0.2450   -1.4000   +1.6500\n +1.7000   +0.9820   +0.1800   -1.2000   +1.7000\n +1.7500   +0.9896   +0.1250   -1.0000   +1.7500\n +1.8000   +0.9947   +0.0800   -0.8000   +1.8000\n +1.8500   +0.9978   +0.0450   -0.6000   +1.8500\n +1.9000   +0.9993   +0.0200   -0.4000   +1.9000\n +1.9500   +0.9999   +0.0050   -0.2000   +1.9500\n +2.0000   +1.0000   +0.0000   +0.0000   +2.0000\n";

    @Before
    public void setUpStreams() {
        this.oldOut = System.out;
        System.setOut(new PrintStream(this.outContent));
    }

    @After
    public void cleanUpStreams() {
        System.setOut(this.oldOut);
    }

    @Test
    public void samplingAndInverse() {
        int NUM_SAMPLES = 41;
        double TIME = 2.0;
        double DIST = 1.0;
        CubicSCurve scu = new CubicSCurve(1.0, 2.0);
        System.out.printf("Time      Distance  Velocity  Accel     inv Dist%n", new Object[0]);
        System.out.printf("--------  --------  --------  --------  --------%n", new Object[0]);
        for (int i = 0; i < 41; ++i) {
            double t = (double)i * 2.0 / 40.0;
            System.out.printf("%+8.4f  %+8.4f  %+8.4f  %+8.4f  %+8.4f%n", t, scu.distance(t), scu.velocity(t), scu.acceleration(t), scu.inverseDistance(scu.distance(t)));
        }
        Assert.assertEquals((Object)correctOutput, (Object)this.outContent.toString());
        System.err.println(this.outContent.toString());
    }
}

