/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.sim;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.lsst.ccs.subsystem.shutter.sim.MotionProfile;
import org.lsst.ccs.subsystem.shutter.sim.PredictedPosition;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public final class PredictedTrajectory {
    private final List<PredictedPosition> positions;

    public PredictedTrajectory(double startPosition, CCSTimeStamp startTime, Duration dt, int numSamples, MotionProfile profile) {
        Instant t0 = startTime.getUTCInstant();
        double totalTime = (double)((long)(numSamples - 1) * dt.toNanos()) * 1.0E-9;
        this.positions = Stream.iterate(t0, t -> t.plus(dt)).limit(numSamples).map(t -> {
            CCSTimeStamp stamp = CCSTimeStamp.currentTimeFromMillis((long)t.toEpochMilli());
            double s = (double)Duration.between(t0, stamp.getUTCInstant()).toNanos() * 1.0E-9;
            return new PredictedPosition(stamp, profile.acceleration(s), profile.velocity(s), startPosition + profile.distance(s));
        }).collect(Collectors.toList());
    }

    public List<PredictedPosition> getPositions() {
        return this.positions;
    }
}

