/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.sim.test;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.shutter.sim.CubicSCurve;

public class PrototypeSCurveTest {
    private static final String CORRECT_OUTPUT1 = "Time      Distance  Velocity  Accel     inv Dist\n--------  --------  --------  --------  --------\n +0.0000   +0.0000   +0.0000   +0.0000   +0.0000\n +0.0500   +0.0001   +0.0050   +0.2000   +0.0500\n +0.1000   +0.0007   +0.0200   +0.4000   +0.1000\n +0.1500   +0.0023   +0.0450   +0.6000   +0.1500\n +0.2000   +0.0053   +0.0800   +0.8000   +0.2000\n +0.2500   +0.0104   +0.1250   +1.0000   +0.2500\n +0.3000   +0.0180   +0.1800   +1.2000   +0.3000\n +0.3500   +0.0286   +0.2450   +1.4000   +0.3500\n +0.4000   +0.0427   +0.3200   +1.6000   +0.4000\n +0.4500   +0.0608   +0.4050   +1.8000   +0.4500\n +0.5000   +0.0833   +0.5000   +2.0000   +0.5000\n +0.5500   +0.1108   +0.5950   +1.8000   +0.5500\n +0.6000   +0.1427   +0.6800   +1.6000   +0.6000\n +0.6500   +0.1786   +0.7550   +1.4000   +0.6500\n +0.7000   +0.2180   +0.8200   +1.2000   +0.7000\n +0.7500   +0.2604   +0.8750   +1.0000   +0.7500\n +0.8000   +0.3053   +0.9200   +0.8000   +0.8000\n +0.8500   +0.3522   +0.9550   +0.6000   +0.8500\n +0.9000   +0.4007   +0.9800   +0.4000   +0.9000\n +0.9500   +0.4501   +0.9950   +0.2000   +0.9500\n +1.0000   +0.5000   +1.0000   +0.0000   +1.0000\n +1.0500   +0.5499   +0.9950   -0.2000   +1.0500\n +1.1000   +0.5993   +0.9800   -0.4000   +1.1000\n +1.1500   +0.6477   +0.9550   -0.6000   +1.1500\n +1.2000   +0.6947   +0.9200   -0.8000   +1.2000\n +1.2500   +0.7396   +0.8750   -1.0000   +1.2500\n +1.3000   +0.7820   +0.8200   -1.2000   +1.3000\n +1.3500   +0.8214   +0.7550   -1.4000   +1.3500\n +1.4000   +0.8573   +0.6800   -1.6000   +1.4000\n +1.4500   +0.8893   +0.5950   -1.8000   +1.4500\n +1.5000   +0.9167   +0.5000   -2.0000   +1.5000\n +1.5500   +0.9393   +0.4050   -1.8000   +1.5500\n +1.6000   +0.9573   +0.3200   -1.6000   +1.6000\n +1.6500   +0.9714   +0.2450   -1.4000   +1.6500\n +1.7000   +0.9820   +0.1800   -1.2000   +1.7000\n +1.7500   +0.9896   +0.1250   -1.0000   +1.7500\n +1.8000   +0.9947   +0.0800   -0.8000   +1.8000\n +1.8500   +0.9978   +0.0450   -0.6000   +1.8500\n +1.9000   +0.9993   +0.0200   -0.4000   +1.9000\n +1.9500   +0.9999   +0.0050   -0.2000   +1.9500\n +2.0000   +1.0000   +0.0000   +0.0000   +2.0000\n";
    private static final String CORRECT_OUTPUT2 = "Time      Distance  Velocity  Accel     inv Dist\n--------  --------  --------  --------  --------\n +0.0000   +0.0000   +0.0000   +0.0000   +0.0000\n +0.0183   +0.0001   +0.0137   +1.5012   +0.0183\n +0.0365   +0.0007   +0.0548   +3.0024   +0.0365\n +0.0548   +0.0023   +0.1233   +4.5037   +0.0548\n +0.0730   +0.0053   +0.2192   +6.0049   +0.0730\n +0.0913   +0.0104   +0.3425   +7.5061   +0.0913\n +0.1095   +0.0180   +0.4932   +9.0073   +0.1095\n +0.1277   +0.0286   +0.6712  +10.5085   +0.1277\n +0.1460   +0.0427   +0.8767  +12.0098   +0.1460\n +0.1643   +0.0608   +1.1096  +13.5110   +0.1643\n +0.1825   +0.0833   +1.3699  +15.0122   +0.1825\n +0.2007   +0.1107   +1.6301  +13.5110   +0.2007\n +0.2190   +0.1427   +1.8630  +12.0098   +0.2190\n +0.2373   +0.1786   +2.0685  +10.5085   +0.2373\n +0.2555   +0.2180   +2.2466   +9.0073   +0.2555\n +0.2738   +0.2604   +2.3973   +7.5061   +0.2738\n +0.2920   +0.3053   +2.5205   +6.0049   +0.2920\n +0.3103   +0.3522   +2.6164   +4.5037   +0.3103\n +0.3285   +0.4007   +2.6849   +3.0024   +0.3285\n +0.3468   +0.4501   +2.7260   +1.5012   +0.3467\n +0.3650   +0.5000   +2.7397   +0.0000   +0.3650\n +0.3833   +0.5499   +2.7260   -1.5012   +0.3832\n +0.4015   +0.5993   +2.6849   -3.0024   +0.4015\n +0.4197   +0.6477   +2.6164   -4.5037   +0.4197\n +0.4380   +0.6947   +2.5205   -6.0049   +0.4380\n +0.4563   +0.7396   +2.3973   -7.5061   +0.4563\n +0.4745   +0.7820   +2.2466   -9.0073   +0.4745\n +0.4928   +0.8214   +2.0685  -10.5085   +0.4927\n +0.5110   +0.8573   +1.8630  -12.0098   +0.5110\n +0.5293   +0.8893   +1.6301  -13.5110   +0.5293\n +0.5475   +0.9167   +1.3699  -15.0122   +0.5475\n +0.5658   +0.9393   +1.1096  -13.5110   +0.5658\n +0.5840   +0.9573   +0.8767  -12.0098   +0.5840\n +0.6023   +0.9714   +0.6712  -10.5085   +0.6023\n +0.6205   +0.9820   +0.4932   -9.0073   +0.6205\n +0.6388   +0.9896   +0.3425   -7.5061   +0.6388\n +0.6570   +0.9947   +0.2192   -6.0049   +0.6570\n +0.6752   +0.9978   +0.1233   -4.5037   +0.6753\n +0.6935   +0.9993   +0.0548   -3.0024   +0.6935\n +0.7118   +0.9999   +0.0137   -1.5012   +0.7118\n +0.7300   +1.0000   +0.0000   -0.0000   +0.7300\n";

    @Test
    public void samplingAndInverse1() {
        this.runSampling(2.0, CORRECT_OUTPUT1);
    }

    @Test
    public void samplingAndInverse2() {
        this.runSampling(0.73, CORRECT_OUTPUT2);
    }

    private void runSampling(double moveTime, String correctOutput) {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outContent);
        int NUM_SAMPLES = 41;
        double DIST = 1.0;
        CubicSCurve scu = new CubicSCurve(1.0, moveTime);
        out.printf("Time      Distance  Velocity  Accel     inv Dist%n", new Object[0]);
        out.printf("--------  --------  --------  --------  --------%n", new Object[0]);
        for (int i = 0; i < 41; ++i) {
            double t = (double)i * moveTime / 40.0;
            out.printf("%+8.4f  %+8.4f  %+8.4f  %+8.4f  %+8.4f%n", t, scu.distance(t), scu.velocity(t), scu.acceleration(t), scu.inverseDistance(scu.distance(t)));
        }
        System.err.println(outContent.toString());
        Assert.assertEquals((Object)correctOutput, (Object)outContent.toString());
    }
}

