package org.lsst.ccs.subsystem.shutter.sim;

import org.lsst.ccs.subsystem.shutter.common.TimeOrdered;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

/**
 * A data point in the prediction of a blade set trajectory. Each point contains
 * a time, acceleration value, velocity value and position value. Times
 * are absolute timestamps. Positions are measured in normalized units
 * where zero is the home position and 1.0 the fully extended position.
 * <p>
 * 
 * <p> Instances are immutable.
 * 
 * @author azemoon
 * @author tether
 */
public class PredictedPosition implements TimeOrdered {

    private final CCSTimeStamp time;
    private final double acceleration;
    private final double velocity;
    private final double position;

    /**
     * Constructs an instance from the field values.
     * @param time the time at which this point was generated.
     * @param acceleration the second time derivative of the normalized position.
     * @param velocity the rate of change of the normalized position.
     * @param position the normalized position.
     */
    public PredictedPosition(CCSTimeStamp time, double acceleration, double velocity, double position) {
        this.time = time;
        this.acceleration = acceleration;
        this.velocity = velocity;
        this.position = position;
    }

    /**
     * Gets the position.
     * @return the position
     */
    public double getPosition() {
        return position;
    }

    /**
     * Gets the time of the sample.
     * @return the time
     */
    @Override
    public CCSTimeStamp getTime() {
        return time;
    }

    /**
     * Gets the acceleration in units of 1/sec/sec.
     * @return the acceleration
     */
    public double getAcceleration() {
        return acceleration;
    }

    /**
     * Gets the velocity in units of 1/sec.
     * @return the velocity
     */
    public double getVelocity() {
        return velocity;
    }
}
