package org.lsst.ccs.subsystem.shutter.common;

import java.io.Serializable;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

/**
 ***************************************************************************
 **
 **  Immutable class containing the data for a transition of a Hall sensor.
 **
 **  @author Owen Saxton
 **  @author tether
 **
 ***************************************************************************
 */
public final class HallTransition implements Serializable, TimeOrdered {

    private static final long serialVersionUID = 1L;

    final CCSTimeStamp time;     // time of transition.
    final int      sensor;       // ID of sensor
    final double   position;     // Blade set position assigned to this transition.
    final boolean  on;           // The transition was from off to on.

    /**
     * Full constructor.
     * @param time          The time of the transition.
     * @param sensor        The ID number of the sensor.
     * @param position      The encoder position in mm assigned to the transition, derived from
     * the last calibration of the Hall sensor readout.
     * @param on True if the transition left the Hall switch in the "on" state.
     */
    public HallTransition(CCSTimeStamp time, int sensor, double position, boolean on)
    {
        this.time        = time;
        this.sensor      = sensor;
        this.position    = position;
        this.on          = on;
    }

    /**
     * Gets the time of the transition.
     * @return the transition time.
     */
    @Override
    public CCSTimeStamp getTime()
    {
        return time;
    }

    /**
     * Gets the Hall sensor ID number.
     * @return the ID number
     */
    public int getSensorId()
    {
        return sensor;
    }

    /**
     * Gets the absolute position of the transition.
     * @return the absolute position in mm
     */
    public double getPosition()
    {
        return position;
    }
    
    /**
     * Gets the polarity of the Hall transition.
     * @return true if the transition was from off to on, else false.
     */
    public boolean isOn() {return on;}

}
