package org.lsst.ccs.subsystems.shutter.status;

/**
 * Published in order to advertise that the shutter worker is ready (or not) to accept a new command.
 * @author azemoon
 * @author tether
 */
public class ReadyForActionStatus implements java.io.Serializable {

    private final boolean readyForAction;
    

    /** 
     * Constructs an instance from a ready-flag.
     * @param readyForAction the flag
     */
    public ReadyForActionStatus(boolean readyForAction) {
        this.readyForAction = readyForAction;
    }

    /**
     * Is the worker subsystem ready?
     * @return the ready-flag
     */
    public boolean isReadyForAction() {
        return readyForAction;
    }
}
