package org.lsst.ccs.subsystems.shutter.status;

import org.lsst.ccs.subsystems.shutter.common.ShutterSide;

/**
 * Published by the shutter worker in acknowledgment of an open command. Immutable.
 * @author tether
 */
public class OpenShutterStatus implements java.io.Serializable {

    private final ShutterSide firstSide;
    private final double moveTime;
    private final long startTime;

    /**
     * Constructs an instance from the field values.
     * @param firstSide the first blade set to be moved
     * @param moveTime the duration of the blade set motion in seconds
     */
    public OpenShutterStatus(ShutterSide firstSide, double moveTime) {
        this.moveTime = moveTime;
        this.firstSide = firstSide;
        this.startTime = System.currentTimeMillis() * 1000;
    }

    /**
     * Gets the first blade set to be moved in the open operation.
     * @return the index
     */
    public ShutterSide getfirstSide() {
        return firstSide;
    }

    /**
     * Gets the duration in seconds of each blade set move.
     * @return the duration
     */
    public double getMoveTime() {
        return moveTime;
    }
    
    /**
     * Gets the time at which the worker subsystem started executing the command.
     * This will be the system time in microseconds at the time of construction of this object.
     * @return the time
     */
    public long getStartTime() {
        return startTime;
    }

}
