package org.lsst.ccs.subsystems.shutter.sim;

/**
 * Represents a simulated motor position sample.
 * 
 * <p>The time for each sample is
 * an absolute system time in microseconds. Only relative blade set positions are used
 * (see {@link org.lsst.ccs.subsystems.shutter.common.BladePosition}).
 * The velocity units are 1/sec and the acceleration units are 1/sec/sec.
 * 
 * <p> Instances are immutable.
 * 
 * @author azemoon
 * @author tether
 */
public class MotorPosition {

    private final long time;
    private final double position;
    private final double acceleration;
    private final double velocity;

    /**
     * Constructs an instance from the field values.
     * @param position the relative position
     * @param velocity the rate of change of relative position
     * @param acceleration the second time derivative of the relative position
     * @param time the time in microseconds
     */
    public MotorPosition(double position, double velocity, double acceleration, long time) {
        this.time = time;
        this.position = position;
        this.velocity = velocity;
        this.acceleration = acceleration;
    }

    /**
     * Gets the relative position.
     * @return the position
     */
    public double getPosition() {
        return position;
    }

    /**
     * Gets the time of the sample.
     * @return the time
     */
    public long getTime() {
        return time;
    }

    /**
     * Gets the acceleration in units of 1/sec/sec.
     * @return the acceleration
     */
    public double getAcceleration() {
        return acceleration;
    }

    /**
     * Gets the velocity in units of 1/sec.
     * @return the velocity
     */
    public double getVelocity() {
        return velocity;
    }
}
