package org.lsst.ccs.subsystems.shutter.common;

/**
 * Represents the two sides of the camera X axis.
 * @author tether
 */
public enum ShutterSide {
    
    /** The +X side. */
    PLUSX,
    
    /** The -X side. */
    MINUSX;
    
    /**
     * Gets the side opposite to this side.
     * @return the opposite side
     */
    public ShutterSide opposite() {
        return ShutterSide.values()[1 - this.ordinal()];
    }
}
