package org.lsst.ccs.subsystems.shutter.common;

import java.lang.reflect.Constructor;
import org.lsst.ccs.drivers.parker.ControllerType;

/**
 * Contains general shutter configuration not related to Hall sensors
 * or individual blade sets.
 * <p>
 *  See <a href="https://confluence.slac.stanford.edu/x/FKnPD">this Confluence page</a>
 *  for descriptions of the configuration parameters.
 * @author tether
 */
public class ShutterConfiguration {

    /**
     * Gets the constructor to be used when making an instance of this class using data from an external
     * source such as a text file. This will generally be a human-readable source, other wise we could have
     * used deserialization.
     *
     * @return A reference to a {@code Constructor<BladeSetConfiguration>}.
     */
    public static Constructor<ShutterConfiguration> getConstructor() {
        try {
            return ShutterConfiguration.class.getDeclaredConstructor(
                double.class,
                double.class,
                double.class,
                double.class,
                ControllerType.class,
                double.class,
                double.class
            );
        } catch (NoSuchMethodException exc) {
            // We've screwed up and let this code get out of sync with the constructor.
            throw new Error("Bug in class ShutterConfiguration!", exc);
        }
    }
    
    private final double moveTime;
    private final double minApproach;
    private final double posTolerance;
    private final double idleTimeout;
    private final ControllerType controller;
    private final double minSampleDt;
    private final double sampleDtScale;

    public ShutterConfiguration(
        double moveTime,
        double minApproach,
        double posTolerance,
        double idleTimeout,
        ControllerType controller,
        double minSampleDt,
        double sampleDtScale
    )
    {
        this.moveTime = moveTime;
        this.minApproach = minApproach;
        this.posTolerance = posTolerance;
        this.idleTimeout = idleTimeout;
        this.controller = controller;
        this.minSampleDt = minSampleDt;
        this.sampleDtScale = sampleDtScale;
    }

    public double getMoveTime() {
        return moveTime;
    }

    public double getMinApproach() {
        return minApproach;
    }

    public double getPosTolerance() {
        return posTolerance;
    }

    public double getIdleTimeout() {
        return idleTimeout;
    }

    public ControllerType getController() {
        return controller;
    }

    public double getMinSampleDt() {
        return minSampleDt;
    }

    public double getSampleDtScale() {
        return sampleDtScale;
    }
    
    
}
