/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.sim.test;

import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystems.shutter.sim.CubicSCurve;
import org.lsst.ccs.subsystems.shutter.sim.HallSensorSimulator;
import org.lsst.ccs.subsystems.shutter.sim.MotionProfile;

public class HallSensorSimulatorTest {
    @Test
    public void extendingBladeset() {
        double MOVE_DISTANCE = 1.0;
        double MOVE_TIME = 1.0;
        double START_POSITION = 0.0;
        String expected = "\nmicrosec  sensor  state   direction   position\n--------  ------  ------  ----------  --------\n  132832       0  closed  extending     0.0125\n  152055       0  open    extending     0.0188\n  208555       0  closed  extending     0.0484\n  217175       0  open    extending     0.0546\n  250923       0  closed  extending     0.0843\n  256983       0  open    extending     0.0905\n  282712       0  closed  extending     0.1201\n  287666       0  open    extending     0.1264\n  309604       0  closed  extending     0.1560\n  313965       0  open    extending     0.1623\n  333680       0  closed  extending     0.1919\n  337667       0  open    extending     0.1981\n  355912       0  closed  extending     0.2278\n  359640       0  open    extending     0.2340\n  376848       0  closed  extending     0.2637\n  380391       0  open    extending     0.2699\n  396841       0  closed  extending     0.2995\n  400247       0  open    extending     0.3058\n  416135       1  closed  extending     0.3354\n  419439       1  open    extending     0.3417\n  434913       1  closed  extending     0.3713\n  438142       1  open    extending     0.3775\n  453317       1  closed  extending     0.4072\n  456493       1  open    extending     0.4134\n  471466       1  closed  extending     0.4431\n  474609       1  open    extending     0.4493\n  489464       1  closed  extending     0.4789\n  492592       1  open    extending     0.4852\n  507408       1  closed  extending     0.5148\n  510536       1  open    extending     0.5211\n  525391       1  closed  extending     0.5507\n  528534       1  open    extending     0.5569\n  543507       1  closed  extending     0.5866\n  546683       1  open    extending     0.5928\n  561858       1  closed  extending     0.6225\n  565087       1  open    extending     0.6287\n  580561       2  closed  extending     0.6583\n  583865       2  open    extending     0.6646\n  599753       2  closed  extending     0.6942\n  603159       2  open    extending     0.7005\n  619609       2  closed  extending     0.7301\n  623152       2  open    extending     0.7363\n  640360       2  closed  extending     0.7660\n  644088       2  open    extending     0.7722\n  662333       2  closed  extending     0.8019\n  666320       2  open    extending     0.8081\n  686035       2  closed  extending     0.8377\n  690396       2  open    extending     0.8440\n  712334       2  closed  extending     0.8736\n  717288       2  open    extending     0.8799\n  743017       2  closed  extending     0.9095\n  749077       2  open    extending     0.9157\n  782825       2  closed  extending     0.9454\n  791445       2  open    extending     0.9516\n  847945       3  closed  extending     0.9813\n  867168       3  open    extending     0.9875\n";
        Assert.assertEquals((Object)"\nmicrosec  sensor  state   direction   position\n--------  ------  ------  ----------  --------\n  132832       0  closed  extending     0.0125\n  152055       0  open    extending     0.0188\n  208555       0  closed  extending     0.0484\n  217175       0  open    extending     0.0546\n  250923       0  closed  extending     0.0843\n  256983       0  open    extending     0.0905\n  282712       0  closed  extending     0.1201\n  287666       0  open    extending     0.1264\n  309604       0  closed  extending     0.1560\n  313965       0  open    extending     0.1623\n  333680       0  closed  extending     0.1919\n  337667       0  open    extending     0.1981\n  355912       0  closed  extending     0.2278\n  359640       0  open    extending     0.2340\n  376848       0  closed  extending     0.2637\n  380391       0  open    extending     0.2699\n  396841       0  closed  extending     0.2995\n  400247       0  open    extending     0.3058\n  416135       1  closed  extending     0.3354\n  419439       1  open    extending     0.3417\n  434913       1  closed  extending     0.3713\n  438142       1  open    extending     0.3775\n  453317       1  closed  extending     0.4072\n  456493       1  open    extending     0.4134\n  471466       1  closed  extending     0.4431\n  474609       1  open    extending     0.4493\n  489464       1  closed  extending     0.4789\n  492592       1  open    extending     0.4852\n  507408       1  closed  extending     0.5148\n  510536       1  open    extending     0.5211\n  525391       1  closed  extending     0.5507\n  528534       1  open    extending     0.5569\n  543507       1  closed  extending     0.5866\n  546683       1  open    extending     0.5928\n  561858       1  closed  extending     0.6225\n  565087       1  open    extending     0.6287\n  580561       2  closed  extending     0.6583\n  583865       2  open    extending     0.6646\n  599753       2  closed  extending     0.6942\n  603159       2  open    extending     0.7005\n  619609       2  closed  extending     0.7301\n  623152       2  open    extending     0.7363\n  640360       2  closed  extending     0.7660\n  644088       2  open    extending     0.7722\n  662333       2  closed  extending     0.8019\n  666320       2  open    extending     0.8081\n  686035       2  closed  extending     0.8377\n  690396       2  open    extending     0.8440\n  712334       2  closed  extending     0.8736\n  717288       2  open    extending     0.8799\n  743017       2  closed  extending     0.9095\n  749077       2  open    extending     0.9157\n  782825       2  closed  extending     0.9454\n  791445       2  open    extending     0.9516\n  847945       3  closed  extending     0.9813\n  867168       3  open    extending     0.9875\n", (Object)this.makeTable(0.0, 1.0, 1.0));
    }

    @Test
    public void retractingBladeset() {
        double MOVE_DISTANCE = -0.5;
        double MOVE_TIME = 1.0;
        double START_POSITION = 0.5;
        String expected = "\nmicrosec  sensor  state   direction   position\n--------  ------  ------  ----------  --------\n  177110       1  closed  retracting    0.4852\n  199157       1  open    retracting    0.4789\n  266934       1  closed  retracting    0.4493\n  277617       1  open    retracting    0.4431\n  321376       1  closed  retracting    0.4134\n  329639       1  open    retracting    0.4072\n  366044       1  closed  retracting    0.3775\n  373277       1  open    retracting    0.3713\n  406127       1  closed  retracting    0.3417\n  412816       1  open    retracting    0.3354\n  443738       0  closed  retracting    0.3058\n  450132       0  open    retracting    0.2995\n  480071       0  closed  retracting    0.2699\n  486336       0  open    retracting    0.2637\n  515983       0  closed  retracting    0.2340\n  522252       0  open    retracting    0.2278\n  552232       0  closed  retracting    0.1981\n  558640       0  open    retracting    0.1919\n  589653       0  closed  retracting    0.1623\n  596368       0  open    retracting    0.1560\n  629387       0  closed  retracting    0.1264\n  636668       0  open    retracting    0.1201\n  673392       0  closed  retracting    0.0905\n  681751       0  open    retracting    0.0843\n  726258       0  closed  retracting    0.0546\n  737217       0  open    retracting    0.0484\n  808423       0  closed  retracting    0.0188\n  832642       0  open    retracting    0.0125\n";
        Assert.assertEquals((Object)"\nmicrosec  sensor  state   direction   position\n--------  ------  ------  ----------  --------\n  177110       1  closed  retracting    0.4852\n  199157       1  open    retracting    0.4789\n  266934       1  closed  retracting    0.4493\n  277617       1  open    retracting    0.4431\n  321376       1  closed  retracting    0.4134\n  329639       1  open    retracting    0.4072\n  366044       1  closed  retracting    0.3775\n  373277       1  open    retracting    0.3713\n  406127       1  closed  retracting    0.3417\n  412816       1  open    retracting    0.3354\n  443738       0  closed  retracting    0.3058\n  450132       0  open    retracting    0.2995\n  480071       0  closed  retracting    0.2699\n  486336       0  open    retracting    0.2637\n  515983       0  closed  retracting    0.2340\n  522252       0  open    retracting    0.2278\n  552232       0  closed  retracting    0.1981\n  558640       0  open    retracting    0.1919\n  589653       0  closed  retracting    0.1623\n  596368       0  open    retracting    0.1560\n  629387       0  closed  retracting    0.1264\n  636668       0  open    retracting    0.1201\n  673392       0  closed  retracting    0.0905\n  681751       0  open    retracting    0.0843\n  726258       0  closed  retracting    0.0546\n  737217       0  open    retracting    0.0484\n  808423       0  closed  retracting    0.0188\n  832642       0  open    retracting    0.0125\n", (Object)this.makeTable(0.5, -0.5, 1.0));
    }

    private String makeTable(double startPosition, double moveDistance, double moveTime) {
        CubicSCurve profile = new CubicSCurve(moveDistance, moveTime);
        HallSensorSimulator hall = new HallSensorSimulator(0L, startPosition, startPosition + moveDistance, (MotionProfile)profile);
        StringBuilder out = new StringBuilder();
        out.append("\nmicrosec  sensor  state   direction   position\n");
        out.append("--------  ------  ------  ----------  --------\n");
        hall.getTransitions().forEach(htr -> out.append(String.format("%8d  %6d  %-6s  %-10s  %8.4f%n", htr.getTransitionTime(), htr.getSensorId(), htr.isOpen() ? "open" : "closed", htr.isReverse() ? "retracting" : "extending", htr.getRelPosition())));
        System.out.print(out);
        return out.toString();
    }
}

