package org.lsst.ccs.subsystems.shutter.status;

import org.lsst.ccs.subsystems.shutter.common.ShutterSide;

/**
 * Published in acknowledgment of a takeExposure command. Immutable.
 * @author azemoon
 * @author tether
 */
public class TakeExposureStatus implements java.io.Serializable {

    private final double exposureTime;
    private final ShutterSide firstSide;
    private final double moveTime;
    private final long startTime;

    /**
     * Constructs an instance from the field values.
     * @param firstSide the side (blade set) of the shutter to move first
     * @param moveTime the duration in seconds of each blade set move
     * @param exposureTime the duration of the exposure in seconds
     */
    public TakeExposureStatus(ShutterSide firstSide, double moveTime, double exposureTime) {
        this.firstSide = firstSide;
        this.moveTime = moveTime;
        this.exposureTime = exposureTime;
        this.startTime = System.currentTimeMillis() * 1000;
    }

    /**
     * Gets the exposure time in seconds.
     * @return the time
     */
    public double getExposureTime() {
        return exposureTime;
    }

    /**
     * Gets the shutter side of the first blade set to be moved for this command.
     * @return the side
     */
    public ShutterSide getFirstSide() {
        return firstSide;
    }

    /**
     * Gets the duration in seconds of each blade set move.
     * @return the duration
     */
    public double getMoveTime() {
        return moveTime;
    }
    
    /**
     * Gets the time at which the worker subsystem started executing the command.
     * This will be the system time in microseconds at the time of construction of this object.
     * @return the time
     */
    public long getStartTime() {
        return startTime;
    }

}
