package org.lsst.ccs.subsystems.shutter.status;

/**
 * Sent by the shutter worker as the result of the getBladePositions() action command. Immutable.
 * @author tether
 */
public class BladePositionResult implements java.io.Serializable {
    private final double plusx, minusx;
    
    /**
     * Constructs an instance from the two blade set positions.
     * @param plusx the relative position of blade set PLUSX
     * @param minusx the relative position of blade set MINUSX
     */
    public BladePositionResult(double plusx, double minusx) {
        this.plusx = plusx; this.minusx = minusx;
    }
    
    /**
     * Gets the relative position of blade set PLUSX.
     * @return the relative position
     */
    public double getPlusx() {return plusx;}
    
    /**
     * Gets the relative position of blade set MINUSX.
     * @return the relative position
     */
    public double getMinusx() {return minusx;}
    
    /**
     * Gives a string of the form "Blade set PLUSX at %6.3f, blade set MINUSX at %6.3f.".
     * @return the string
     */
    @Override
    public String toString() {
        return String.format("Blade set PLUSX at %6.3f, blade set MINUSX at %6.3f.", plusx, minusx);
    }
}
