package org.lsst.ccs.subsystems.shutter.sim;

/**
 * Describes the physical motion of a blade set.
 * 
 * At any time t that's during the motion of a blade set, provide
 * the distance traveled, the velocity and the acceleration. Actually, when we
 * talk about the motion of the blade set we really mean the motion of
 * its leading edge.
 * 
 * @author tether
 */
public interface MotionProfile {
    
    /**
     * Gives the distance traveled by the blade set at time t.
     * @param t a time between 0.0 and the amount of time allowed for the motion, inclusive
     * @return the distance traveled at time t. Negative for a retraction
     * @throws IllegalArgumentException if t is invalid
     */
    double distance(double t);
    
    /**
     * Gives the velocity of the blade set at time t.
     * @param t a time between 0.0 and the amount of time allowed for the motion, inclusive
     * @return the velocity at time t
     * @throws IllegalArgumentException if t is invalid
     */
    double velocity(double t);
    
    /**
     * Gives the acceleration of the blade set at time t.
     * @param t a time between 0.0 and the amount of time allowed for the motion, inclusive.
     * @return the acceleration at time t.
     * @throws IllegalArgumentException if t is invalid.  
     */
    double acceleration(double t);
    
    /**
     * Provides the time t at which the
     * distance had a given value d.
     * Assumes that the motion is monotonic; no reversals of the direction of travel.
     * @param d the distance, between 0.0 and the total distance traveled, inclusive.
     *          Negative for a retraction.
     * @return the time at which the distance traveled was d
     * @throws IllegalArgumentException if d is invalid
     */
    double inverseDistance(double d);
}
