/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.sim;

import java.util.Random;
import java.util.function.Function;
import org.lsst.ccs.subsystems.shutter.common.BladePosition;
import org.lsst.ccs.subsystems.shutter.sim.MotorPosition;

public class MotorEncoderSimulator
implements Function<MotorPosition, BladePosition> {
    public static final double JITTER_STDDEV = 1.0E-4;
    public static final double MAX_JITTER = 5.0E-4;
    private final Random random = new Random();

    @Override
    public BladePosition apply(MotorPosition p) {
        double jitter = this.random.nextGaussian() * 1.0E-4;
        if (Math.abs(jitter) > 5.0E-4) {
            jitter = 5.0E-4 * Math.signum(jitter);
        }
        double position = p.getPosition() + this.random.nextGaussian() * 1.0E-4;
        BladePosition bladePosition = new BladePosition(p.getTime(), 0.0, position);
        return bladePosition;
    }
}

