/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.sim.test;

import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystems.shutter.common.BladePosition;
import org.lsst.ccs.subsystems.shutter.common.HallTransition;
import org.lsst.ccs.subsystems.shutter.common.MovementHistory;
import org.lsst.ccs.subsystems.shutter.common.ShutterSide;
import org.lsst.ccs.subsystems.shutter.sim.BladeSetSimulator;

public class BladeSetSImulatorTest {
    @Test
    public void moveBladeSet() {
        BladeSetSimulator blade = new BladeSetSimulator(ShutterSide.MINUSX, null, null, null);
        Assert.assertEquals((String)"Blade set index check", (Object)blade.getSide(), (Object)ShutterSide.MINUSX);
        Assert.assertEquals((String)"Blade initial position check", (double)blade.getRelativePosition(), (double)0.0, (double)0.0);
        MovementHistory hist = blade.moveToPosition(1.0, 1.0);
        this.printMovement(hist);
        this.checkCommon(hist);
        hist.getPositions().stream().mapToDouble(BladePosition::getRelPosition).reduce(-100.0, (x, y) -> {
            Assert.assertTrue((String)"Blade position strict increase check", (y > x ? 1 : 0) != 0);
            return y;
        });
        hist.getHallTransitions().stream().mapToDouble(HallTransition::getRelPosition).reduce(-100.0, (x, y) -> {
            Assert.assertTrue((String)"Hall transition position strict increase check", (y > x ? 1 : 0) != 0);
            return y;
        });
        hist.getHallTransitions().stream().forEach(trans -> Assert.assertFalse((String)"Hall isReverse() check", (boolean)trans.isReverse()));
        hist = blade.moveToPosition(0.0, 1.0);
        this.printMovement(hist);
        this.checkCommon(hist);
        hist.getPositions().stream().mapToDouble(BladePosition::getRelPosition).reduce(100.0, (x, y) -> {
            Assert.assertTrue((String)"Blade position strict decrease check", (y < x ? 1 : 0) != 0);
            return y;
        });
        hist.getHallTransitions().stream().mapToDouble(HallTransition::getRelPosition).reduce(100.0, (x, y) -> {
            Assert.assertTrue((String)"Hall transition position strict decrease check", (y < x ? 1 : 0) != 0);
            return y;
        });
        hist.getHallTransitions().stream().forEach(trans -> Assert.assertTrue((String)"Hall isReverse() check", (boolean)trans.isReverse()));
    }

    private void printMovement(MovementHistory hist) {
        System.out.print("Start time: ");
        System.out.println(hist.getStartTime());
        System.out.print("Start position: ");
        System.out.println(hist.getStartPosition());
        System.out.print("End time: ");
        System.out.println(hist.getEndTime());
        System.out.print("End position: ");
        System.out.println(hist.getEndPosition());
        System.out.print("Move status: ");
        System.out.println(hist.getStatus());
        System.out.print("Blade side: ");
        System.out.println(hist.getSide());
        System.out.println("\nHall transitions:");
        System.out.println("microsecs             ID  state   direction  position");
        System.out.println("--------------------  --  ------  ---------  --------");
        hist.getHallTransitions().forEach(trans -> System.out.format("%020d  %2d  %6s  %9s  %8.4f%n", trans.getTransitionTime(), trans.getSensorId(), trans.isOpen() ? "open" : "closed", trans.isReverse() ? "reverse" : "forward", trans.getRelPosition()));
        System.out.println("\nBlade positions:");
        System.out.println("microsecs             position");
        System.out.println("--------------------  --------");
        hist.getPositions().forEach(pos -> System.out.format("%020d  %8.4f%n", pos.getTime(), pos.getRelPosition()));
    }

    private void checkCommon(MovementHistory hist) {
        Assert.assertNotEquals((String)"Nonempty blade position list check", (long)hist.getPositions().size(), (long)0L);
        Assert.assertNotEquals((String)"Nonempty Hall transition list check", (long)hist.getHallTransitions().size(), (long)0L);
        Assert.assertEquals((String)"Hall transition times range check", (long)hist.getHallTransitions().stream().mapToLong(HallTransition::getTransitionTime).filter(t -> t < hist.getStartTime() || t > hist.getEndTime()).count(), (long)0L);
        Assert.assertEquals((String)"Blade position times range check", (long)hist.getPositions().stream().mapToLong(BladePosition::getTime).filter(t -> t < hist.getStartTime() || t > hist.getEndTime()).count(), (long)0L);
        hist.getHallTransitions().stream().mapToLong(HallTransition::getTransitionTime).reduce(0L, (x, y) -> {
            Assert.assertTrue((String)"Hall transition times strict increase check", (y > x ? 1 : 0) != 0);
            return y;
        });
        hist.getPositions().stream().mapToLong(BladePosition::getTime).reduce(0L, (x, y) -> {
            Assert.assertTrue((String)"Blade sample times strict increase check", (y > x ? 1 : 0) != 0);
            return y;
        });
        hist.getHallTransitions().stream().map(HallTransition::isOpen).reduce(!((HallTransition)hist.getHallTransitions().get(0)).isOpen(), (x, y) -> {
            Assert.assertTrue((String)"Hall state alternation check", (boolean)(x ^ y));
            return y;
        });
    }
}

