package org.lsst.ccs.subsystems.shutter.common;

import java.lang.reflect.Constructor;

/**
 * The configuration data for a single Hall sensor. Immutable.
 * <p>
 *  See <a href="https://confluence.slac.stanford.edu/x/FKnPD">this Confluence page</a>
 *  for descriptions of the configuration parameters.
 * @author tether
 */
public class HallConfiguration {

    /**
     * Gets the constructor to be used when making an instance of this class using data from an external
     * source such as a text file. This will generally be a human-readable source, other wise we could have
     * used deserialization.
     *
     * @return A reference to a {@code Constructor<HallConfiguration>}.
     */
    public static Constructor<HallConfiguration> getConstructor() {
        try {
            return HallConfiguration.class.getDeclaredConstructor(
                int.class,
                double.class,
                double.class,
                double.class,
                double.class,
                double.class
            );
        } catch (NoSuchMethodException exc) {
            // We've screwed up and let this code get out of sync with the constructor.
            throw new Error("Bug in class HallConfiguration!", exc);
        }
    }
    
    final private int ident;
    final private double inFlip;
    final private double outFlip;
    final private double position;
    final private double port;
    final private double line;

    public HallConfiguration(
        int ident,
        double inFlip,
        double outFlip,
        double position,
        double port,
        double line
    )
    {
        this.ident = ident;
        this.inFlip = inFlip;
        this.outFlip = outFlip;
        this.position = position;
        this.port = port;
        this.line = line;
    }

    public int getIdent() {
        return ident;
    }

    public double getInFlip() {
        return inFlip;
    }

    public double getOutFlip() {
        return outFlip;
    }

    public double getPosition() {
        return position;
    }

    public double getPort() {
        return port;
    }

    public double getLine() {
        return line;
    }
 
}
