/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.sim;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.lsst.ccs.subsystems.shutter.common.HallTransition;
import org.lsst.ccs.subsystems.shutter.sim.MotionProfile;

public class HallSensorSimulator {
    private static final int NUM_MAGNETS = 9;
    private static final int NUM_SENSORS = 4;
    private static final double SENSOR_WINDOW_OFFSET = 0.0125;
    private static final double SENSOR_WINDOW_SIZE = 0.00625;
    private static final double TRANSITION_PAIR_SPACING = 0.03587962962962963;
    private final HallTransition[] transitions;

    public HallSensorSimulator(long startTime, double startPosition, double endPosition, MotionProfile profile) {
        int NUM_TRANSITIONS = 72;
        boolean retracting = endPosition < startPosition;
        double top = Math.max(startPosition, endPosition);
        double bottom = Math.min(startPosition, endPosition);
        IntStream indexes = !retracting ? IntStream.range(0, 72) : IntStream.iterate(71, i -> i - 1).limit(72L);
        this.transitions = (HallTransition[])indexes.mapToObj(itrans -> {
            int sensorId = itrans / 9 / 2;
            int ipair = itrans >> 1;
            boolean even = (itrans & 1) == 0;
            boolean firstOfPair = even ^ retracting;
            double pos = 0.0125 + (double)ipair * 0.03587962962962963 + (even ? 0.0 : 0.00625);
            return new SensorData(sensorId, firstOfPair, pos);
        }).filter(data -> data.position <= top && data.position >= bottom).map(data -> {
            double pos = data.position - startPosition;
            long microsecs = startTime + Math.round(1000000.0 * profile.inverseDistance(pos));
            return new HallTransition(microsecs, data.sensorId, !data.firstOfPair, retracting, 0.0, data.position);
        }).toArray(HallTransition[]::new);
    }

    public Stream<HallTransition> getTransitions() {
        return Stream.of(this.transitions);
    }

    private static class SensorData {
        public final int sensorId;
        public final boolean firstOfPair;
        public final double position;
        public long time;

        public SensorData(int id, boolean first, double pos) {
            this.sensorId = id;
            this.firstOfPair = first;
            this.position = pos;
        }
    }
}

