/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.sim;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.lsst.ccs.subsystems.shutter.common.BladePosition;
import org.lsst.ccs.subsystems.shutter.common.BladeSet;
import org.lsst.ccs.subsystems.shutter.common.BladeSetConfiguration;
import org.lsst.ccs.subsystems.shutter.common.MovementHistory;
import org.lsst.ccs.subsystems.shutter.sim.CubicSCurve;
import org.lsst.ccs.subsystems.shutter.sim.HallSensorSimulator;
import org.lsst.ccs.subsystems.shutter.sim.MotorEncoderSimulator;
import org.lsst.ccs.subsystems.shutter.sim.MotorSimulator;

public final class BladeSetSimulator
implements BladeSet {
    private final int index;
    private volatile double position;

    public BladeSetSimulator(int index) {
        this.index = index == 0 ? 0 : 1;
        this.position = this.index == 0 ? 0.0 : 1.0;
    }

    @Override
    public BladeSetConfiguration getBladeSetConfiguration() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getCurrentPosition() {
        return this.position;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public MovementHistory moveToPosition(double targetPosition, double moveTimeSeconds) {
        int numSamples = (int)(1L + Math.round(moveTimeSeconds / 0.05));
        double dt = moveTimeSeconds / (double)(numSamples - 1);
        double startPosition = this.getCurrentPosition();
        long startTime = System.currentTimeMillis() * 1000L;
        CubicSCurve profile = new CubicSCurve(targetPosition - this.getCurrentPosition(), moveTimeSeconds);
        MotorSimulator motor = new MotorSimulator(startPosition, dt, numSamples, startTime, profile);
        MotorEncoderSimulator encoder = new MotorEncoderSimulator();
        HallSensorSimulator hall = new HallSensorSimulator(startTime, startPosition, targetPosition, profile);
        List bladePos = motor.getPositions().map(encoder).collect(Collectors.toList());
        List hallTrans = hall.getTransitions().collect(Collectors.toList());
        long endTime = ((BladePosition)bladePos.get(bladePos.size() - 1)).getTime();
        this.position = targetPosition;
        return new MovementHistory(this.getIndex(), 1, startTime, startPosition, endTime, targetPosition, Collections.unmodifiableList(bladePos), Collections.unmodifiableList(hallTrans));
    }
}

