/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.common;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Scanner;
import org.lsst.ccs.subsystems.shutter.common.BladeSetCalibration;

public final class BladeSetConfiguration
implements Serializable {
    private static final double POS_SOFT_LIM = 1.05;
    private static final double NEG_SOFT_LIM = -0.05;
    private final int index;
    private final String node;
    private final double ppMm;
    private final double homePosn;
    private final double openPosn;
    private final double clsdPosn;
    private final int numSamp;
    private final double moveTime;
    private final int dioAddr;
    private final int dioLevel;
    private final int dioConf;
    private final int dioHPort;
    private final int dioOPort;
    private final int dioOLine;
    private final int dioIPort;
    private final int dioILine;
    private final int adAddr;
    private final int adLevel;
    private final int adTempChn;
    private final BladeSetCalibration calib;
    private static final String[] CALIB_FILE = new String[]{"Calibration_0.dat", "Calibration_1.dat"};
    private static final PrintStream out = System.out;

    public BladeSetConfiguration(int index) {
        this.index = index;
        if (index == 0) {
            this.node = "192.168.100.1";
            this.ppMm = -49.3504;
            this.homePosn = 0.0;
            this.openPosn = 0.0;
            this.clsdPosn = 760.0;
            this.moveTime = 1.0;
            this.numSamp = 100;
            this.dioAddr = 832;
            this.dioLevel = 6;
            this.dioConf = 7;
            this.dioHPort = 0;
            this.dioIPort = 2;
            this.dioILine = 0;
            this.dioOPort = 2;
            this.dioOLine = 4;
            this.adAddr = 640;
            this.adLevel = 5;
            this.adTempChn = 0;
        } else {
            this.node = "192.168.100.1";
            this.ppMm = 49.3504;
            this.homePosn = 760.0;
            this.openPosn = 760.0;
            this.clsdPosn = 0.0;
            this.moveTime = 1.0;
            this.numSamp = 100;
            this.dioAddr = 832;
            this.dioLevel = 6;
            this.dioConf = 7;
            this.dioHPort = 0;
            this.dioIPort = 2;
            this.dioILine = 0;
            this.dioOPort = 2;
            this.dioOLine = 4;
            this.adAddr = 640;
            this.adLevel = 5;
            this.adTempChn = 0;
        }
        this.calib = BladeSetConfiguration.readCalibration(index);
    }

    public int getIndex() {
        return this.index;
    }

    public BladeSetCalibration getCalibration() {
        return this.calib;
    }

    public String getNode() {
        return this.node;
    }

    public double getPpMm() {
        return this.ppMm;
    }

    public double getHome() {
        return this.homePosn;
    }

    public double getOpen() {
        return this.openPosn;
    }

    public double getClosed() {
        return this.clsdPosn;
    }

    public double getMoveTime() {
        return this.moveTime;
    }

    public int getNumSamp() {
        return this.numSamp;
    }

    public int getDioAddr() {
        return this.dioAddr;
    }

    public int getDioLevel() {
        return this.dioLevel;
    }

    public int getDioConf() {
        return this.dioConf;
    }

    public int getDioHPort() {
        return this.dioHPort;
    }

    public int getDioIPort() {
        return this.dioIPort;
    }

    public int getDioILine() {
        return this.dioILine;
    }

    public int getDioOPort() {
        return this.dioOPort;
    }

    public int getDioOLine() {
        return this.dioOLine;
    }

    public int getAdAddr() {
        return this.adAddr;
    }

    public int getAdLevel() {
        return this.adLevel;
    }

    public int getAdTempChn() {
        return this.adTempChn;
    }

    public double ppu() {
        return Math.abs(this.ppMm);
    }

    public double motorDistance(double dist) {
        return Math.signum(this.ppMm) * dist;
    }

    public double position(int encoder) {
        return this.homePosn + (double)encoder / this.ppMm;
    }

    public double position(double relPosition) {
        return this.openPosn + relPosition * (this.clsdPosn - this.openPosn);
    }

    public double relPosition(int encoder) {
        return ((double)encoder / this.ppMm + this.homePosn - this.openPosn) / (this.clsdPosn - this.openPosn);
    }

    public double relPosition(double position) {
        return (position - this.openPosn) / (this.clsdPosn - this.openPosn);
    }

    public double posSoftLimit() {
        double reach = Math.signum(this.ppMm) * (this.clsdPosn - this.openPosn);
        return (reach > 0.0 ? 1.05 : -0.05) * reach;
    }

    public double negSoftLimit() {
        double reach = Math.signum(this.ppMm) * (this.clsdPosn - this.openPosn);
        return (reach > 0.0 ? -0.05 : 1.05) * reach;
    }

    public static BladeSetCalibration readCalibration(int index) {
        return BladeSetConfiguration.readCalibration(CALIB_FILE[index]);
    }

    public static BladeSetCalibration readCalibration(String file) {
        FileInputStream ifl;
        try {
            ifl = new FileInputStream(file);
        }
        catch (IOException e) {
            out.println(e);
            return null;
        }
        ArrayList<BladeSetCalibration.Item> items = new ArrayList<BladeSetCalibration.Item>();
        Scanner inp = new Scanner(ifl);
        int line = 0;
        int field = 0;
        int sensor = 0;
        int indx = 0;
        boolean open = false;
        boolean reverse = false;
        try {
            while (inp.hasNext()) {
                switch (field) {
                    case 0: {
                        reverse = inp.next("[+-]").equals("-");
                        break;
                    }
                    case 1: {
                        sensor = inp.nextInt();
                        break;
                    }
                    case 2: {
                        indx = inp.nextInt();
                        break;
                    }
                    case 3: {
                        open = inp.next("[OC]").equals("O");
                        break;
                    }
                    case 4: {
                        double posn = inp.nextDouble();
                        items.add(new BladeSetCalibration.Item(sensor, indx, posn, open, reverse));
                        field = -1;
                        ++line;
                        inp.nextLine();
                    }
                }
                ++field;
            }
        }
        catch (NoSuchElementException e) {
            out.format("Invalid field (%s) in line %s\n", field + 1, line + 1);
            return null;
        }
        if (field != 0) {
            out.format("File ended unexpectedly in line %s\n", line + 1);
            return null;
        }
        try {
            ifl.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new BladeSetCalibration(0, items);
    }

    public void writeCalibration() {
        BladeSetConfiguration.writeCalibration(this.calib, CALIB_FILE[this.index]);
    }

    public void writeCalibration(BladeSetCalibration calib) {
        BladeSetConfiguration.writeCalibration(calib, CALIB_FILE[this.index]);
    }

    public void writeCalibration(String file) {
        BladeSetConfiguration.writeCalibration(this.calib, file);
    }

    public static void writeCalibration(BladeSetCalibration calib, String file) {
        PrintStream ofl;
        try {
            ofl = new PrintStream(file);
        }
        catch (IOException e) {
            out.println(e);
            return;
        }
        calib.getData().stream().forEach(tran -> ofl.format("%s %s %s %s %8.2f\n", tran.isReverse() ? "-" : "+", tran.getSensor(), tran.getIndex(), tran.isOpen() ? "O" : "C", tran.getPosition()));
        ofl.close();
    }
}

