/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.sim.test;

import java.util.DoubleSummaryStatistics;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.subsystems.shutter.common.BladePosition;
import org.lsst.ccs.subsystems.shutter.sim.MotorEncoderSimulator;
import org.lsst.ccs.subsystems.shutter.sim.MotorPosition;
import org.lsst.ccs.subsystems.shutter.sim.test.MotorSimulatorTest;

public class MotorEncoderSimulatorTest {
    private Stream<MotorPosition> posStream;
    private static final MotorEncoderSimulator encoder = new MotorEncoderSimulator();

    @Before
    public void makePosStream() {
        this.posStream = MotorSimulatorTest.standardMotorSimulator().getPositions();
    }

    @Test
    public void checkTimes() {
        this.posStream.forEach(mpos -> {
            BladePosition bpos = encoder.apply(mpos);
            Assert.assertEquals((long)bpos.getTime(), (long)mpos.getTime());
        });
    }

    @Test
    public void checkMaxPositionDiff() {
        this.posStream.forEach(mpos -> {
            BladePosition bpos = encoder.apply(mpos);
            double delta = Math.abs(bpos.getRelPosition() - mpos.getPosition());
            Assert.assertTrue((delta <= 5.01E-4 ? 1 : 0) != 0);
        });
    }

    @Test
    public void checkPositionDiffMS() {
        DoubleSummaryStatistics stats = this.posStream.mapToDouble(mpos -> {
            BladePosition bpos = encoder.apply(mpos);
            double delta = bpos.getRelPosition() - mpos.getPosition();
            return delta * delta;
        }).summaryStatistics();
        double msj = stats.getSum() / (double)(stats.getCount() - 1L);
        System.out.format("Mean square jitter = %e%n", msj);
        Assert.assertTrue((String)"Mean square jitter check", (msj > 1.0E-12 ? 1 : 0) != 0);
    }
}

