package org.lsst.ccs.subsystems.shutter.status;

/**
 * Published in acknowledgment of a takeExposure command. Immutable.
 * @author azemoon
 * @author tether
 */
public class TakeExposureStatus implements java.io.Serializable {

    private final double exposureTime;
    private final int firstBladeSetIndex;
    private final double moveTime;
    private final long startTime;

    /**
     * Constructs an instance from the field values.
     * @param firstBladeSetIndex the index, 0 or 1, of the first blade set to be moved
     * @param moveTime the duration in seconds of each blade set move
     * @param exposureTime the duration of the exposure in seconds
     */
    public TakeExposureStatus(int firstBladeSetIndex, double moveTime, double exposureTime) {
        this.firstBladeSetIndex = firstBladeSetIndex;
        this.moveTime = moveTime;
        this.exposureTime = exposureTime;
        this.startTime = System.currentTimeMillis() * 1000;
    }

    /**
     * Gets the exposure time in seconds.
     * @return the time
     */
    public double getExposureTime() {
        return exposureTime;
    }

    /**
     * Gets the index, 0 or 1, of the first blade set to be moved for this command.
     * @return the index
     */
    public int getfirstBladeSetIndex() {
        return firstBladeSetIndex;
    }

    /**
     * Gets the duration in seconds of each blade set move.
     * @return the duration
     */
    public double getMoveTime() {
        return moveTime;
    }
    
    /**
     * Gets the time at which the worker subsystem started executing the command.
     * This will be the system time in microseconds at the time of construction of this object.
     * @return the time
     */
    public long getStartTime() {
        return startTime;
    }

}
