package org.lsst.ccs.subsystems.shutter.status;

/**
 * @brief Enumerations for the keys used in publishing shutter subsystem status messages.
 *
 * Each enumerator holds a string that should be used as a key when calling Configurable.publish(). t was felt better to
 * collect the keys in one place rather than to distribute them among the status class definitions.
 */
public enum StatusKey {
    /**
     * For a CloseShutterStatus.
     */
    CLOSE_SHUTTER("closeShutter"),
    /**
     * For an OpenShutterStatus.
     */
    OPEN_SHUTTER("openShutter"),
    /**
     * For a MoveBladeSetStatus.
     */
    MOVE_BLADE_SET("moveBladeSet"),
    /**
     * For a MovementStatus.
     */
    MOVEMENT("movement"),
    /**
     * For a ReadyStatus.
     */
    READY("ready"),
    /**
     * For a ShutterConfigStatus.
     */
    SHUTTER_CONFIG("shutterConfig"),
    /**
     * For a TakeExposureStatus.
     */
    TAKE_EXPOSURE("takeExposure"),
    /**
     * For an UnsafeMoveStatus.
     */
    UNSAFE_MOVE("unsafeMove");

    /** The string form of the instance, to be used as a key in calls to publish(). */
    private final String key;
    
    /**
     * Save the key value.
     *
     * @param key The string value.
     */
    StatusKey(String key) {
        this.key = key;
    }

    /**
     * Retrieve the key value.
     * @return The key value.
     */
    public String getKey() {
        return key;
    }
    
    
}
