package org.lsst.ccs.subsystems.shutter.status;

/**
 * Used to publish all shutter configuration parameter values after any change. Immutable.
 * @author turri
 * @author tether
 */
public class ShutterConfigStatus implements java.io.Serializable {

    private final double bladeMovementTime, bladeSetEndTol, bladeSetApproachMin;

    /**
     * Construct an instance from the configuration parameter values.
     * @param bladeMovementTime the duration of each blade movement in seconds
     * @param bladeSetEndTol how close, in relative position, the blade set has to be to 0.0
     * or 1.0 to be considered open or closed, respectively
     * @param bladeSetApproachMin how close, in relative position, the two blade sets are allowed to
     * approach one another before a move is considered unsafe
     */
    public ShutterConfigStatus (
        double bladeMovementTime,
        double bladeSetEndTol,
        double bladeSetApproachMin)
    {
        this.bladeMovementTime = bladeMovementTime;
        this.bladeSetEndTol = bladeSetEndTol;
        this.bladeSetApproachMin = bladeSetApproachMin;
    }

    /**
     * Gets the blade movement time.
     * @return the time in seconds
     */
    public double getBladeMovementTime() {
        return bladeMovementTime;
    }
    
    /**
     * Gets the blade set "end tolerance".
     * @return the tolerance in terms of relative position
     */
    public double getBladeSetEndTol() {
        return bladeSetEndTol;
    }
    
    /**
     * Gets the minimum approach distance for the blade sets.
     * @return the distance in terms of relative position
     */
    public double getBladeSetApproachMin() {
        return bladeSetApproachMin;
    }

}
