package org.lsst.ccs.subsystems.shutter.status;

/**
 * Published by the shutter worker in acknowledgment of an open command. Immutable.
 * @author tether
 */
public class OpenShutterStatus implements java.io.Serializable {

    private final int firstBladeSetIndex;
    private final double moveTime;
    private final long startTime;

    /**
     * Constructs an instance from the field values.
     * @param firstBladeSetIndex the index, 0 or 1, of the first blade set to be moved
     * @param moveTime the duration of the blade set motion in seconds
     */
    public OpenShutterStatus(int firstBladeSetIndex, double moveTime) {
        this.moveTime = moveTime;
        this.firstBladeSetIndex = firstBladeSetIndex;
        this.startTime = System.currentTimeMillis() * 1000;
    }

    /**
     * Gets the index, 0 or 1, of the first blade set to be moved in the open operation.
     * @return the index
     */
    public int getfirstBladeSetIndex() {
        return firstBladeSetIndex;
    }

    /**
     * Gets the duration in seconds of each blade set move.
     * @return the duration
     */
    public double getMoveTime() {
        return moveTime;
    }
    
    /**
     * Gets the time at which the worker subsystem started executing the command.
     * This will be the system time in microseconds at the time of construction of this object.
     * @return the time
     */
    public long getStartTime() {
        return startTime;
    }

}
