package org.lsst.ccs.subsystems.shutter.status;

/**
 * Published in acknowledgment of a moveToPosition command. Immutable.
 * @author azemoon
 * @author tether
 */
public class MoveToPositionStatus implements java.io.Serializable {

    private final double startingPosition;
    private final double targetPosition;
    private final int index;
    private final double moveTime;
    private final long startTime;

    /**
     * Constructs an instance from the field values.
     * @param startingPosition the initial relative position of the blade set
     * @param index the index, 0 or 1, of the blade set to be moved
     * @param targetPosition the final relative position of the blade set
     * @param moveTime the duration in seconds of the blade set move
     */
    public MoveToPositionStatus(double startingPosition, int index, double targetPosition, double moveTime) {
        this.startingPosition = startingPosition;
        this.index = index;
        this.targetPosition = targetPosition;
        this.moveTime = moveTime;
        this.startTime = System.currentTimeMillis() * 1000;
    }

    /**
     * Gets the starting relative position.
     * @return the position
     */
    public double getStartingPosition() {
        return startingPosition;
    }

    /**
     * Gets the desired final relative position.
     * @return the position
     */
    public double getTargetPosition() {
        return targetPosition;
    }

    /**
     * Gets the time in seconds that the blade set motion will take.
     * @return the time
     */
    public double getMoveTime() {
        return moveTime;
    }

    /**
     * Gets the index, 0 or 1, of the blade set that will be moved.
     * @return the index
     */
    public int getIndex() {
        return index;
    }
    
    /**
     * Gets the time at which the worker subsystem started executing the command.
     * This will be the system time in microseconds at the time of construction of this object.
     * @return the time
     */
    public long getStartTime() {
        return startTime;
    }

}
