package org.lsst.ccs.subsystems.shutter.status;

/**
 * Sent by the shutter worker as the result of the getBladePositions() action command. Immutable.
 * @author tether
 */
public class BladePositionResult implements java.io.Serializable {
    private final double pos0, pos1;
    
    /**
     * Constructs an instance from the two blade set positions.
     * @param pos0 the relative position of blade set 0
     * @param pos1 the relative position of blade set 1
     */
    public BladePositionResult(double pos0, double pos1) {this.pos0 = pos0; this.pos1= pos1;}
    
    /**
     * Gets the relative position of blade set 0.
     * @return the relative position
     */
    public double getPos0() {return pos0;}
    
    /**
     * Gets the relative position of blade set 1.
     * @return the relative position
     */
    public double getPos1() {return pos1;}
    
    /**
     * Gives a string of the form "Blade set 0 at %6.3f, blade set 1 at %6.3f.".
     * @return the string
     */
    @Override
    public String toString() {
        return String.format("Blade set 0 at %6.3f, blade set 1 at %6.3f.", pos0, pos1);
    }
}
