package org.lsst.ccs.subsystems.shutter.common;

/**
 * The interface to software controlling a single blade set, real or simulated.
 * @author tether
 */
public interface BladeSet {

    /**
     * Gets the current position of the BladeSet. May cause hardware operations.
     *
     * @return  the current relative position of the blade set
     * @see BladePosition
     *
     */
    public double getCurrentPosition();


    /**
     * Moves the blade set to the specified position. May cause hardware operations.
     * @param position  the desired relative position of the leading edge of the blade set
     * @param moveTime  the move duration in seconds
     * @return a MovementHistory instance resulting from the motion
     * 
     * <p>Upon return getCurrentPosition() will reflect the final position of the move in any thread.
     *
     * @throws IllegalArgumentException if position is not valid
     *
     */
    public MovementHistory moveToPosition(double position, double moveTime);

    /**
     * Gets the index of the blade set. The index specifies which physical blade set this object represents.
     * @return the index (0 or 1)
     */
    public int getIndex();

    /**
     * Gets the configuration of the BladeSet.
     *
     * @return  the BladeSet configuration
     *
     */
    public BladeSetConfiguration getBladeSetConfiguration();
    
    /**
     * Initializes any underlying hardware, etc. The default is to do nothing.
     */
    public default void init() {}

}
