/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.simulator.motor;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorListener;
import org.lsst.ccs.subsystems.shutter.simulator.motor.MotorPosition;

public class MotorSimulator {
    static final int PERIOD = 50;
    private ArrayList<MotorListener> listeners = new ArrayList();
    private double velocity;
    private double acceleration;
    private double initialPosition;
    private List<MotorPosition> motorPositions = new ArrayList<MotorPosition>();
    private int index;
    private boolean retracting;

    public void addMotorListener(MotorListener l) {
        this.listeners.add(l);
    }

    public void removeMotorListener(MotorListener l) {
        this.listeners.remove(l);
    }

    public void simulateMovement(final float targetPosition, double moveTimeSeconds) throws IllegalArgumentException {
        if (targetPosition < 0.0f || targetPosition > 1.0f) {
            throw new IllegalArgumentException("Illegal targetPosition " + targetPosition + " outside [0,1]");
        }
        if (moveTimeSeconds <= 0.0) {
            throw new IllegalArgumentException("Illegal moveTimeSeconds" + moveTimeSeconds + "<=0");
        }
        this.retracting = (double)targetPosition < this.initialPosition;
        System.out.println("===================================================");
        System.out.println("MotorSimulator: currentPosition " + this.initialPosition + " target position " + targetPosition);
        int moveTime = (int)(1000.0 * moveTimeSeconds);
        this.getMotorPositions(targetPosition, moveTime);
        this.index = 0;
        final Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (MotorSimulator.this.index < MotorSimulator.this.motorPositions.size()) {
                    MotorSimulator.this.fireMotorChangedEvent((MotorPosition)MotorSimulator.this.motorPositions.get(MotorSimulator.this.index));
                } else {
                    MotorSimulator.this.fireMotorStoppedEvent();
                    MotorSimulator.this.initialPosition = targetPosition;
                    MotorSimulator.this.velocity = 0.0;
                    MotorSimulator.this.acceleration = 0.0;
                    timer.cancel();
                    MotorSimulator.this.motorPositions.clear();
                    MotorSimulator motorSimulator = MotorSimulator.this;
                    synchronized (motorSimulator) {
                        MotorSimulator.this.notifyAll();
                    }
                }
                MotorSimulator motorSimulator = MotorSimulator.this;
                motorSimulator.index = motorSimulator.index + 1;
            }
        }, 0L, 50L);
    }

    private void getMotorPositions(float targetPosition, int moveTime) {
        double distance = (double)targetPosition - this.initialPosition;
        long start = System.currentTimeMillis();
        long end = start + (long)moveTime;
        System.out.println("MotorSimulator: start " + start + " end " + end);
        double delta = 50.0 / (double)moveTime;
        long time = start;
        double position = this.initialPosition;
        this.motorPositions.add(new MotorPosition(this.initialPosition, 0.0, 0.0, start));
        double x = delta;
        while (x <= 1.0) {
            this.acceleration = MotorSimulator.calculateAcceleration(x);
            this.velocity += 4.0 * this.acceleration * delta;
            System.out.println("MotorSimulator: " + x + " " + (position += 2.0 * this.velocity * delta * distance) + " " + this.velocity + " " + this.acceleration + " " + (time += 50L));
            this.motorPositions.add(new MotorPosition(position, this.velocity, this.acceleration, time));
            x += delta;
        }
        this.motorPositions.add(new MotorPosition(targetPosition, 0.0, 0.0, start + (long)moveTime));
    }

    private static double calculateAcceleration(double phase) {
        if (phase < 0.25) {
            return phase * 4.0;
        }
        if (phase < 0.75) {
            return 1.0 - (phase - 0.25) * 4.0;
        }
        return phase * 4.0 - 4.0;
    }

    public double getInitialMotorPosition() {
        return this.initialPosition;
    }

    public void setInitialMotorPosition(double position) {
        if (position < 0.0 || position > 1.0) {
            throw new IllegalArgumentException("Illegal targetPosition " + position + " outside [0,1]");
        }
        this.initialPosition = position;
    }

    private void fireMotorChangedEvent(MotorPosition p) {
        for (MotorListener l : new ArrayList<MotorListener>(this.listeners)) {
            l.positionChanged(p);
        }
    }

    private void fireMotorStoppedEvent() {
        for (MotorListener l : new ArrayList<MotorListener>(this.listeners)) {
            l.motorStopped();
        }
    }

    public boolean isRetracting() {
        return this.retracting;
    }

    synchronized void waitForMovementToComplete() throws InterruptedException {
        this.wait();
    }
}

