package org.lsst.ccs.subsystems.shutter.common;

import java.io.Serializable;

/**
 ***************************************************************************
 **
 **  Class containing the data for a single Hall sensor transition
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class HallTransition implements Serializable {

    long     time;         // Microseconds since epoch
    int      sensor;       // ID of sensor
    boolean  open;         // True if sensor opened; false if closed
    boolean  reverse;      // True if motion reverse; false if forward
    float    position;     // Position of this transition (mm from origin)
    float    relPosition;  // Relative position of this transition (0 - 1)


    public HallTransition()
    {
    }


    public HallTransition(long time, int sensor, boolean open,
                              boolean reverse, float position,
                              float relPosition)
    {
        this.time        = time;
        this.sensor      = sensor;
        this.open        = open;
        this.reverse     = reverse;
        this.position    = position;
        this.relPosition = relPosition;
    }


    public void setTransitionTime(long time)
    {
        this.time = time;
    }


    public void setSensorId(int sensor)
    {
        this.sensor = sensor;
    }


    public void setOpen(boolean open)
    {
        this.open = open;
    }


    public void setReverse(boolean reverse)
    {
        this.reverse = reverse;
    }


    public void setPosition(float position)
    {
        this.position = position;
    }


    public void setRelPosition(float relPosition)
    {
        this.relPosition = relPosition;
    }


    public long getTransitionTime()
    {
        return time;
    }


    public int getSensorId()
    {
        return sensor;
    }


    public boolean isOpen()
    {
        return open;
    }


    public boolean isReverse()
    {
        return reverse;
    }


    public float getPosition()
    {
        return position;
    }


    public float getRelPosition()
    {
        return relPosition;
    }

}
