package org.lsst.ccs.subsystems.shutter.common;

import java.io.Serializable;

/**
 ***************************************************************************
 **
 **  Class containing the data for a single blade position sample
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class BladePosition implements Serializable {

    long     time;          // Epoch microseconds
    float    position;      // Blade position (mm from shutter origin)
    float    relPosition;   // Relative blade position


    public BladePosition()
    {
    }


    public BladePosition(long time, float position, float relPosition) {
        this.time = time;
        this.position = position;
        this.relPosition = relPosition;
    }


    public BladePosition(float position, float relPosition) {
        this.time = System.currentTimeMillis() * 1000;
        this.position = position;
        this.relPosition = relPosition;
    }


    public void setTime(long time)
    {
        this.time = time;
    }


    public void setPosition(float position)
    {
        this.position = position;
    }


    public void setRelPosition(float relPosition)
    {
        this.relPosition = relPosition;
    }


    public long getTime()
    {
        return time;
    }


    public float getPosition()
    {
        return position;
    }


    public float getRelPosition()
    {
        return relPosition;
    }

}
