/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.refrig.ui;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandAck;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.subsystems.refrig.status.RefrigChannelLimitStatus;
import org.lsst.ccs.subsystems.refrig.status.RefrigConfigurationSavedStatus;
import org.lsst.ccs.subsystems.refrig.status.RefrigTrendingStatus;
import org.lsst.ccs.subsystems.refrig.status.RefrigTrendingSummaryStatus;
import org.lsst.ccs.subsystems.refrig.ui.RefrigAssembly;

public class RefrigGUISubsystem
extends Subsystem {
    static final int NOT_INITIALIZED = 0;
    static final int INITIALIZATION_REQUEST_SENT = 5;
    static final int INITIALIZING = 10;
    static final int INITIALIZED = 15;
    static final String refrig_dest = "ccs-refrig";
    private MessagingFactory mfac;
    PrintWriter out = new PrintWriter(new OutputStreamWriter(System.out));
    RefrigAssembly assembly = new RefrigAssembly(this);
    private long lastHeartBeat;
    int currentStatus = 0;

    public void initGui() {
        this.setName("RefrigerationGUIModule");
        this.mfac = MessagingFactory.getInstance().forSubsystem(this.getName());
        this.setListenToStatus(true);
        this.setStatusBroadcastPeriod(0);
        this.start();
        Timer t = new Timer();
        t.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                long delta = (System.currentTimeMillis() - RefrigGUISubsystem.this.lastHeartBeat) / 1000L;
                if (RefrigGUISubsystem.this.currentStatus != 0 && delta > 30L) {
                    RefrigGUISubsystem.this.resetGui();
                }
            }
        }, new Date(), 5000L);
    }

    void sendCommandToInitializeGui() {
        this.currentStatus = 5;
        ModuleInvokerCommand cmd = new ModuleInvokerCommand("publishTrendingSummary", new Object[0]);
        cmd.setDestination(refrig_dest);
        this.mfac.sendCommand((Command)cmd);
    }

    public void resetGui() {
        this.assembly.getTrendingTable().resetTrendingTableModel();
        this.currentStatus = 0;
    }

    public JComponent getGuiLayout() {
        return this.assembly;
    }

    public static void main(String[] args) {
        System.setProperty("java.naming.factory.initial", "com.sun.enterprise.naming.SerialInitContextFactory");
        System.setProperty("java.naming.factory.url.pkgs", "com.sun.enterprise.naming");
        System.setProperty("java.naming.factory.state", "com.sun.corba.ee.impl.presentation.rmi.JNDIStateFactoryImpl");
        System.setProperty("org.omg.CORBA.ORBInitialHost", "localhost");
        System.setProperty("org.omg.CORBA.ORBInitialPort", "3700");
        RefrigGUISubsystem t = new RefrigGUISubsystem();
        JFrame frame = new JFrame("Refrigeration Subsystem");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(3);
    }

    public void setPrintWriter(PrintWriter out) {
        this.out = out;
    }

    public void onStatus(BusMessage s) {
        if (this.currentStatus == 15) {
            if (s instanceof RefrigTrendingStatus) {
                this.assembly.getTrendingTable().updateTableValue((RefrigTrendingStatus)s);
                this.assembly.getControlPanel().updateControlPanel((RefrigTrendingStatus)s);
            } else if (s instanceof RefrigChannelLimitStatus) {
                this.assembly.getTrendingTable().updateTableValue((RefrigChannelLimitStatus)s);
            } else if (s instanceof RefrigConfigurationSavedStatus) {
                this.assembly.getTrendingTable().configurationSaved();
            }
        }
        if (s.getOrigin().equals(refrig_dest)) {
            this.lastHeartBeat = s.getTimeStamp();
            if (this.currentStatus == 0) {
                this.sendCommandToInitializeGui();
            }
            if (this.currentStatus == 5 && s instanceof RefrigTrendingSummaryStatus) {
                RefrigTrendingSummaryStatus status = (RefrigTrendingSummaryStatus)s;
                this.initializeChannels(status);
            }
        }
    }

    public void submitLimit(int index, double value, boolean isLowLimit) {
        Integer arg1 = index;
        Double arg2 = value;
        String command = isLowLimit ? "setLowLimit" : "setHighLimit";
        ModuleInvokerCommand cmd = new ModuleInvokerCommand(command, new Object[]{arg1, arg2});
        cmd.setDestination(refrig_dest);
        this.mfac.sendCommand((Command)cmd);
    }

    public void saveConfiguration() {
        ModuleInvokerCommand cmd = new ModuleInvokerCommand("saveConfiguration", new Object[0]);
        cmd.setDestination(refrig_dest);
        this.mfac.sendCommand((Command)cmd);
    }

    public void setPowerStatus(boolean enablePower) {
        Integer arg = enablePower ? 1 : 0;
        ModuleInvokerCommand cmd = new ModuleInvokerCommand("setPowerEnable", new Object[]{arg});
        cmd.setDestination(refrig_dest);
        this.mfac.sendCommand((Command)cmd);
    }

    public void setLoadTripStatus(boolean enableLoadTrip) {
        Integer arg = enableLoadTrip ? 1 : 0;
        ModuleInvokerCommand cmd = new ModuleInvokerCommand("setLoadTripEnable", new Object[]{arg});
        cmd.setDestination(refrig_dest);
        this.mfac.sendCommand((Command)cmd);
    }

    public void onReply(CommandReply r) {
    }

    public void onAck(CommandAck a) {
        this.currentStatus = 10;
        System.out.println("*************** got acknolegment " + this.currentStatus);
    }

    private void initializeChannels(RefrigTrendingSummaryStatus status) {
        this.assembly.getTrendingTable().updateTableModel(status);
        this.assembly.getControlPanel().updateControlPanel(status.getRefrigStatus());
        this.currentStatus = 15;
    }
}

